<?php

namespace App\Http\Controllers;

use App\Models\InstallmentDetail;
use App\Models\Installments;
use Illuminate\Http\Request;

class InstallmentDetailController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        $installment = Installments::where('id',$request->installment_id)->first();


        $names = $request->input('name', []);
        $dates = $request->input('date', []);
        $amount = $request->input('amount', []);

        for($i=0;  $i < $installment->total_installments; $i++) {

                $detail = new InstallmentDetail();

                $detail->name = $names[$i];
                $detail->date = $dates[$i];
                $detail->amount = $amount[$i];
                $detail->installment_id = $installment->id;
                $detail->save();

        }

        return redirect()->route('installments.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\InstallmentDetail  $installmentDetail
     * @return \Illuminate\Http\Response
     */
    public function show(InstallmentDetail $installmentDetail)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\InstallmentDetail  $installmentDetail
     * @return \Illuminate\Http\Response
     */
    public function edit($installments)
    {
        $installments = Installments::where('id',$installments)->with('details')->first();

        return view('installments.define',compact('installments'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\InstallmentDetail  $installmentDetail
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, InstallmentDetail $installmentDetail)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\InstallmentDetail  $installmentDetail
     * @return \Illuminate\Http\Response
     */
    public function destroy(InstallmentDetail $installmentDetail)
    {
        //
    }
}
