<?php

namespace App\Http\Controllers;

use App\Models\Allotment;
use App\Models\InstallmentDetail;
use App\Models\Installments;
use App\Models\User;
use App\Models\UserInstallment;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class InstallmentsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $installments = Installments::with(['scheme', 'plot', 'category'])->paginate(10);

        return view('installments.create', compact('installments'));

        // return view('installments.create');
    }

    public function plot_transfer()
    {
        return view('allotments.transfers');
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create($allotmentId)
    {
        // Fetch the allotment
        $allotment = Allotment::find($allotmentId);
        // dd($allotment);
        // Fetch the installment related to the allotment
        $installment = Installments::where('scheme_id', $allotment->scheme_id)
            ->where('category_id', $allotment->quota_category)
            ->where('size_id', $allotment->size_id)
            ->first();
        // dd($installment);

        $installment_details = InstallmentDetail::where('installment_id', $installment->id)->get();

        // Fetch user installments related to the allotment
        $user_installments = UserInstallment::where('allotment_id', $allotmentId)->get();

        // Map user installments by installment detail id
        $user_installments_map = $user_installments->keyBy('installment_detail_id');

        // Pass the required data to the view
        return view('installments.user_installment', [
            'installment_details' => $installment_details,
            'allotment' => $allotment,
            'user_installments' => $user_installments_map,
        ]);
    }

    // public function create($allotment)
    // {
    //     $allotment = Allotment::find($allotment);

    //     // Fetch the installment related to the allotment
    //     $installment = Installments::where('scheme_id', $allotment->scheme_id)
    //         ->where('category_id', $allotment->quota_category)
    //         ->where('size_id', $allotment->size_id)
    //         ->first();

    //     // Fetch installment details
    //     $installment_details = InstallmentDetail::where('installment_id', $installment->id)->get();

    //     // Determine if the installment has been fully received
    //     $isPaid = $installment_details->every(function ($detail) {
    //         return isset($detail->installment->status);
    //     });

    //     // Pass the required data to the view
    //     return view('installments.user_installment', [
    //         'installment_details' => $installment_details,
    //         'allotment' => $allotment,
    //         'isPaid' => $isPaid,
    //     ]);

    // }
    // return view('installments.user_installment', compact('installment', 'allotment', 'installment_details'));

    public function add_installments(Request $request)
    {

        $allotment = Allotment::find($request->allotment);
        $detail = InstallmentDetail::find($request->installment_detail);
        $installment_ = new UserInstallment();
        $installment_->allotment_id = $allotment->id;
        $installment_->scheme_id = $allotment->scheme_id;
        $installment_->installment_detail_id = $request->installment_detail;
        $installment_->amount = $detail->amount;
        $installment_->created_by = Auth::id();
        $installment_->receiving_date = $request->receiving_date;
        $installment_->received_amount = $request->received_amount;

        $installment_->slip_no = $request->slip_no;


        if (isset($request->fine_type)) {

            $installment_->fine_amount  = $this->fine($detail);
        }

        $installment_->save();

        return redirect('/installment/' . $allotment->id);
    }


    public function fine($detail)
    {

        $datetime1 = new DateTime(date('Y-m-d', strtotime($detail->date)));

        $datetime2 = new DateTime();

        $difference = $datetime1->diff($datetime2);

        $fine = 0;

        if ($datetime1 < $datetime2) {
            $fine = ($detail->amount / 100) * 2;

            $d = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($detail->date)), date('Y'));
            $fine = $fine / $d;
        }


        if ('fine_type' == 'two_per_anum') {
            $days = $difference->y * 365;

            $fine = ($detail->amount / 100) * 2;
            $fine =   $fine / $days;
        }

        if ('fine_type' == 'two_per_month') {
            $fine = ($detail->amount / 100) * 2;

            $d = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($detail->date)), date('Y'));
            $fine = $fine / $d;
        }

        if ('fine_type' == 'one_per_month') {
            $fine = ($detail->amount / 100) * 1;

            $d = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($detail->date)), date('Y'));
            $fine = $fine / $d;
        }

        if ('fine_type' == 'two_per_day') {
            $fine = ($detail->amount / 100) * 2;

            $d = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($detail->date)), date('Y'));
            $fine = $fine / 1;
        }

        return $fine;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, Installments $installments)
    {

        $request->validate([
            'size_id' => 'required', 'scheme_id' => 'required', 'category_id' => 'required',
            'total_installments' => 'required'
        ]);

        $installments->create($request->all());


        return redirect()->route('installments.index')->with('created', 'Installments Created Sucessfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Installments  $installments
     * @return \Illuminate\Http\Response
     */
    public function show(Installments $installments)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Installments  $installments
     * @return \Illuminate\Http\Response
     */
    public function edit()
    {
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Installments  $installments
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Installments $installments)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Installments  $installments
     * @return \Illuminate\Http\Response
     */
    public function destroy(Installments $installments)
    {
        //
    }
}
