<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\Contract;
use App\Http\Controllers\Controller;
use App\Models\Inventory;
use App\Models\Assignment;
use App\Models\Department;
use App\Models\Item;
use App\Models\Store;
use App\Models\User;
use Error;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class InventoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $inventory  = Inventory::with('item', 'user', 'store')->paginate(10);

        return view('inventory.index', compact('inventory'));
    }
    public function assign_list()
    {

        // $assignments = Assignment::with(['user', 'department', 'item'])->paginate(10);
        $assignments = Assignment::with(['user', 'department', 'item'])->get();
        // dd($assignment);
        return view('inventory.assignitem_list', compact('assignments'));
    }

    public function assign_create()
    {
        // dd('hello');
        // 
        $users = User::all()->pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');
        $departments = Department::get();
        $stores = Store::all()->pluck('store', 'id')->prepend(trans('global.pleaseSelect'), '');
        $items = Item::all()->pluck('item', 'id')->prepend(trans('global.pleaseSelect'), '');
        $inventory = Inventory::get();
        $user_id = Auth::User()->id;

        return view('inventory.assignitem_create', compact(
            'items',
            'user_id',
            'users',
            'stores',
            'inventory',
            'departments',
        ));
    }

    public function assign_store()
    {
        // dd(request()->all());
        $inventoryId = request()->input('inventory_id');
        $quantity = request()->input('quantity');
        $userId = request()->input('user_id');
        $departmentId = request()->input('department_id');
        $inventory = Inventory::find($inventoryId);
        if (!$inventory) {
            return back()->with('error', 'Inventory item not found.');
        }
        if ($inventory->count < $quantity) {
            return back()->with('error', 'Insufficient inventory quantity.');
        }

        $inventory->available_stock = $inventory->count - $quantity;
        $inventory->save();
        // dd($inventory);

        $assignment = Assignment::create([
            'item_id' => $inventory->item_id,
            'user_id' => $userId,
            'quantity' => $quantity,
            'department_id' => $departmentId,
        ]);
        // dd($assignment);
        return redirect()->route('admin.inventory.assign.list')->with('success', 'Assignment created successfully.');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //        abort_if(Gate::denies('comment_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');


        $date_random_batch = date('Y-m-d / ');

        $date_random_batch .= mt_rand(5, 500000);

        $users = User::all()->pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');
        $stores = Store::all()->pluck('store', 'id')->prepend(trans('global.pleaseSelect'), '');
        $items = Item::all()->pluck('item', 'id')->prepend(trans('global.pleaseSelect'), '');
        $user_id = Auth::User()->id;

        return view('inventory.create', compact(
            'items',
            'user_id',
            'users',
            'stores',
            'date_random_batch'
        ));
    }


    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'batch' => 'required',
            'count' => 'required|integer|min:0',
        ]);
        $data = $request->all();
        $data['available_stock'] = $validatedData['count'];
        $inventory = Inventory::create($data);
        return redirect()->route('inventory.index')->with('success', 'Inventory item added successfully.');
    }




    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Contract  $inventory
     * @return \Illuminate\Http\Response
     */

    public function edit(Inventory $inventory)
    {
        //       abort_if(Gate::denies('comment_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $date_random_batch = date('Y-m-d / ');

        $date_random_batch .= mt_rand(5, 500000);

        $users = User::all()->pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');
        $stores = Store::all()->pluck('store', 'id')->prepend(trans('global.pleaseSelect'), '');
        $items = Item::all()->pluck('item', 'id')->prepend(trans('global.pleaseSelect'), '');
        $user_id = Auth::User()->id;


        $updated_by = Auth::User()->id;

        return view('inventory.edit', compact(
            'items',
            'user_id',
            'users',
            'stores',
            'date_random_batch',
            'inventory'
        ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Contract  $inventory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Inventory $inventory)
    {

        $validatedData = $request->validate([
            'batch' => 'required',
            'count' => 'required|integer|min:0',
        ]);
        $data = $request->all();
        $data['available_stock'] = $validatedData['count'];
        $inventory->update($data);
        return redirect()->route('inventory.index')->with('success', 'Inventory item updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Contract  $inventory
     * @return \Illuminate\Http\Response
     */
    public function destroy(Inventory $inventory)
    {
        //      abort_if(Gate::denies('comment_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $inventory->delete();

        return back();
    }
}
