<?php

namespace App\Http\Controllers;

use App\Models\Payslip;
use App\Models\Employee;
use App\Models\Salary;
use Illuminate\Http\Request;

class PayslipController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function generate($salaryId)
    {
        $salary = Salary::findOrFail($salaryId);

        $payslip = Payslip::create([
            'employee_id' => $salary->employee_id,
            'salary_id' => $salary->id,
            'payslip_number' => 'PS-' . str_pad($salary->id, 8, '0', STR_PAD_LEFT),
        ]);

        return response()->json($payslip);
    }



    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Payslip  $payslip
     * @return \Illuminate\Http\Response
     */
    public function show($payslipId)
    {
        $payslip = Payslip::with(['employee', 'salary'])->findOrFail($payslipId);

        return view('salary.show', compact('payslip'));
    }

    public function showPayslip($employeeId, $month)
    {
        $employee = Employee::with(['salaries', 'allowances'])
            ->where('id', $employeeId)
            ->first();

        if (!$employee) {
            return redirect()->back()->with('error', 'Employee not found');
        }

        // Filter salary for the selected month
        $salary = $employee->salaries
            ->where('salary_month', $month)
            ->first();

        // Filter allowances for the selected month
        $allowances = $employee->allowances
            ->where('for_month', $month);

        return view('salary.show', compact('employee', 'salary', 'allowances'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Payslip  $payslip
     * @return \Illuminate\Http\Response
     */
    public function edit(Payslip $payslip)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Payslip  $payslip
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Payslip $payslip)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Payslip  $payslip
     * @return \Illuminate\Http\Response
     */
    public function destroy(Payslip $payslip)
    {
        //
    }
}
