<?php

namespace App\Http\Controllers;

use App\Models\Salary;
use App\Models\Employee;
use Illuminate\Http\Request;

class SalaryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }




    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'employee_id' => 'required|exists:employees,id',
            'allowances' => 'nullable|numeric',
            'deductions' => 'nullable|numeric',
            'salary_month' => 'required|date',
        ]);

        $employee = Employee::findOrFail($request->employee_id);
        $basicSalary = $employee->basic_salary;

        $allowances = $request->allowances ?? 0;
        $deductions = $request->deductions ?? 0;

        $netSalary = $basicSalary + $allowances - $deductions;

        $salary = Salary::create([
            'employee_id' => $employee->id,
            'basic_salary' => $basicSalary,
            'allowances' => $allowances,
            'deductions' => $deductions,
            'net_salary' => $netSalary,
            'salary_month' => $request->salary_month,
        ]);

        return response()->json($salary);
    }


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Salary  $salary
     * @return \Illuminate\Http\Response
     */
    public function show($employeeId, $month)
    {
        $employee = Employee::with(['salaries', 'allowances'])
            ->where('id', $employeeId)
            ->first();

        if (!$employee) {
            return redirect()->back()->with('error', 'Employee not found');
        }

        // Filter salary for the selected month
        $salary = $employee->salaries
            ->where('salary_month', $month)
            ->first();

        // Filter allowances for the selected month
        $allowances = $employee->allowances
            ->where('for_month', $month);

        return view('payslips.show', compact('employee', 'salary', 'allowances'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Salary  $salary
     * @return \Illuminate\Http\Response
     */
    public function edit(Salary $salary)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Salary  $salary
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Salary $salary)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Salary  $salary
     * @return \Illuminate\Http\Response
     */
    public function destroy(Salary $salary)
    {
        //
    }
}
