<?php

namespace App\Http\Controllers;

use App\Models\QuestionBank;
use App\Models\QuestionOptions;
use App\Models\User;
use App\Models\UserAnswers;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Date;

class UserAnswersController extends Controller
{

public function __construct()
{
$this->middleware('auth');
}

/**
* Display a listing of the resource.
*
* @return \Illuminate\Http\Response
*/
public function index()
{
$user = Auth::user();
$answered = UserAnswers::all();

$questions = QuestionBank::whereNotIn('id',['1,2,3,4,5'])->get();

return view('questions.questions',['user' => $user]);
}

public function decide_question_order(Request $request){


    $step = '';

    if($request->step == 'next_step'){

        $step = '>';
        $order='asc';
    }
     else{
        $step = '<';
         $order='desc';

     }

     $question = QuestionBank::where('id',$step,$request->question_id)->with('options')->orderBy('id',$order)->first();



     if($request->input('checked')){

         UserAnswers::where('user_id',Auth::id())->where('question_id',$request->question_id)->delete();

         foreach ($request->input('checked') as $checked){

             $option = QuestionOptions::find($checked);


                 $answer = new UserAnswers();

                 $answer->option = $option->option;
                 $answer->option_id = $checked;

                 $answer->user_id = Auth::id();

                 $answer->question_id = $request->question_id;

                 $answer->save();

         }

     }else{

         UserAnswers::where('user_id',Auth::id())->where('question_id',$request->question_id)->delete();

     }
    $answers='';
     if(is_null($question)){

         $question['last'] = true;

     }else{
         $answers   = UserAnswers::where('user_id',Auth::id())->where('question_id',$question->id)->get()->toArray();

     }

//   $options = $this->filter_options($question);
    if(!is_null($answers)){
        $question['answers'] = $answers;

    }

     return json_encode($question);

}

public function bmr_questions(){

$weight = config('bmr.weight');

$height = config('bmr.height');

$units[] = $height;
$units[] = $weight;


return view('questions.questions',['height' =>$height, 'weight' =>$weight]);

}

public function get_bmr(Request $request){

$bmr = '';
$user = Auth::user();

$height = $request->height;
$weight = $request->weight;
$dob = $request->dob;


$date = Date::now();

$bday = new DateTime($dob); // Your date of birth
$today = new Datetime(date('m.d.y'));

$age = $today->diff($bday);

//        Men: (10 × weight in kg) + (6.25 × height in cm) - (5 × age in years) + 5

if($user->gender == 'male'){

$bmr = (10 * $weight) + (6.25 * $height) - (5 * $age->y) + 5;

}
//        Women: (10 × weight in kg) + (6.25 × height in cm) - (5 × age in years) - 161

else{
$bmr = (10 * $weight) + (6.25 * $height) - (5 * $age->y) - 161;

}

$user->dob = $bday;
$user->height =  round($height,0);
$user->weight = round($weight,0);
$user->bmr = round($bmr,2);

$user->save();

$array = array();
$array['bmr'] =  round($bmr,2);
$array['age'] =$age->y;
$array['height'] =  round($height,2) ;
$array['weight'] =round($weight,2) ;

return $array;

}


public function add_info(Request $request){

$gender = $request->gender;
$name = $request->name;

$user = Auth::user();

$user->gender=$gender;
$user->name=$name;
$user->save();

return true;

}


/**
* Show the form for creating a new resource.
*
* @return \Illuminate\Http\Response
*/
public function create()
{
    return view('questions.answers',['answers' => QuestionBank::whereNotIn('id',[1,2,3,4,5,6])->get()]);
}

/**
* Store a newly created resource in storage.
*
* @param  \Illuminate\Http\Request  $request
* @return \Illuminate\Http\Response
*/
public function store(Request $request)
{
//
}

/**
* Display the specified resource.
*
* @param  \App\Models\UserAnswers  $userAnswers
* @return \Illuminate\Http\Response
*/
public function show(UserAnswers $userAnswers)
{
//
}

/**
* Show the form for editing the specified resource.
*
* @param  \App\Models\UserAnswers  $userAnswers
* @return \Illuminate\Http\Response
*/
public function edit(UserAnswers $userAnswers)
{
//
}

/**
* Update the specified resource in storage.
*
* @param  \Illuminate\Http\Request  $request
* @param  \App\Models\UserAnswers  $userAnswers
* @return \Illuminate\Http\Response
*/
public function update(Request $request, UserAnswers $userAnswers)
{
//
}

/**
* Remove the specified resource from storage.
*
* @param  \App\Models\UserAnswers  $userAnswers
* @return \Illuminate\Http\Response
*/
public function destroy(UserAnswers $userAnswers)
{
//
}
}
