<?php

namespace App\Models;



use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Company;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

class Contract extends Model implements HasMedia
{
    use HasFactory;
    use InteractsWithMedia;

    protected $fillable = [
        'company_id',
        'details',
        'start_at',
        'end_at',
        'created_by',
        'title','expiry_alert_days','price'
    ];

    protected $appends = [
        'attachments',
    ];
    public function getAttachmentsAttribute()
    {
        return $this->getMedia('attachments');
    }
    public function company()
    {
        return $this->belongsTo(Company::class,'company_id');
    }

}
