<?php

namespace App\Models;


use App\Models\Item;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;


class Inventory extends Model
{
    use HasFactory;
    protected $table   = 'inventory';
    protected $fillable = [
        'item_id',
        'count',
        'price',
        'available_stock',
        'batch',
        'updated_at',
        'created_at',
        'created_by',
        'tenant_id',
        'user_id',
        'store_id',
        'status'
    ];

    public function item()
    {
        return $this->belongsTo(Item::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function store()
    {
        return $this->belongsTo(Store::class);
    }
}
