<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('father_name')->nullable();
            $table->string('email')->unique();
            $table->string('position')->nullable();
            $table->decimal('basic_salary', 10, 2);
            $table->date('appointment_date')->nullable();
            $table->date('promotion_date')->nullable();
            $table->string('job_type')->nullable();
            $table->string('personal_number')->nullable();
            $table->integer('leave_balance')->default(0);
            $table->string('reporting_officer')->nullable();
            $table->integer('sick_leaves')->default(0);
            $table->integer('casual_leaves')->default(0);
            $table->integer('earned_leaves')->default(0);
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees');
    }
};
