<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Add missing columns to employees table
        Schema::table('employees', function (Blueprint $table) {
            $table->string('district_of_domicile')->nullable()->after('earned_leaves');
            $table->string('marital_status')->nullable()->after('district_of_domicile');
            $table->date('date_of_birth')->nullable()->after('marital_status');
            $table->string('city_of_birth')->nullable()->after('date_of_birth');
            $table->date('date_of_marriage')->nullable()->after('city_of_birth');
            $table->string('province_of_domicile')->nullable()->after('date_of_marriage');
            $table->integer('no_of_dependents')->default(0)->after('province_of_domicile');
            $table->string('nationality')->nullable()->after('no_of_dependents');
            $table->string('religion')->nullable()->after('nationality');
        });

        // Add missing columns to salaries table
        Schema::table('salaries', function (Blueprint $table) {
            $table->string('pay_scale_type')->nullable()->after('net_salary');
            $table->integer('pay_scale_level')->nullable()->after('pay_scale_type');
            $table->decimal('gross_salary', 10, 2)->nullable()->after('pay_scale_level');
        });

        // Add missing columns to payrolls table
        Schema::table('payslips', function (Blueprint $table) {
            $table->date('payroll_month')->nullable();
            $table->string('fund_section')->nullable();
            $table->string('payroll_status')->default('Pending');
        });

        // Create allowances table
        Schema::create('allowances', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->decimal('amount', 10, 2);
            $table->timestamps();
        });

        // Create user_allowances table
        Schema::create('user_allowances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained('employees')->onDelete('cascade');
            $table->foreignId('allowance_id')->constrained('allowances')->onDelete('cascade');
            $table->date('for_month');
            $table->decimal('amount', 10, 2);
            $table->timestamps();
        });
    }



    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
};
