<?php

namespace App\Http\Controllers;

use App\Models\Allotment;
use App\Models\InstallmentDetail;
use App\Models\Installments;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AllotmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
        $user = Auth::user();
        $isAdmin = $user->hasRole('admin');

        if ($isAdmin) {
            $allotments = Allotment::with('scheme', 'plot', 'size')
                ->orderBy('id', 'desc')
                ->get();
        } else {
            $allotments = Allotment::with('scheme', 'plot', 'size')
                ->where('creator_id', $user->id)
                ->orderBy('id', 'desc')
                ->get();
        }

        return view('allotments.index', compact('allotments'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view('allotments.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, Allotment $allotment)
    {
        $data = $request->all();
        $data['creator_id'] = Auth::user()->id;

        try {
            $allotment = $allotment->create($data);

            if ($request->hasFile('applicant_image')) {
                $allotment->addMedia($request->file('applicant_image'))->toMediaCollection('allotment');
            }

            $installment = Installments::where('scheme_id', $allotment->scheme_id)
                ->where('category_id', $allotment->quota_category)->where('size_id', $allotment->size_id)->first();

            // $installment_details = InstallmentDetail::where(['allotment_id' => $allotment->id, 'installment_id' => $installment->id])->get();

            // 
            return redirect()->route('allotments.index')->with('alloted', 'Alloted Successfully.');
        } catch (\Exception $exception) {
            echo $exception->getMessage();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Allotment  $allotment
     * @return \Illuminate\Http\Response
     */
    public function show(Allotment $allotment)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Allotment  $allotment
     * @return \Illuminate\Http\Response
     */
    public function edit(Allotment $allotment)
    {


        return view('allotments.edit', compact('allotment'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Allotment  $allotment
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Allotment $allotment)
    {
        $data = $request->all();
        $data['creator_id'] = Auth::user()->id;
        $allotment->update($data);

        if ($request->hasFile('applicant_image')) {

            $media = $allotment->getMedia('allotment');

            if ($media[0]) {

                $media[0]->delete();
            }

            $allotment->addMedia($request->file('applicant_image'))->toMediaCollection('allotment');
        }

        return redirect()->route('allotments.index')->with('updated', 'Allotment updated.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Allotment  $allotment
     * @return \Illuminate\Http\Response
     */
    public function destroy(Allotment $allotment)
    {
        //
    }
}
