<?php

namespace App\Http\Controllers;

use App\Models\Department;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroyCommentRequest;
use App\Http\Requests\StoreCommentRequest;
use App\Http\Requests\UpdateCommentRequest;
 use App\Models\User;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Gate;
class DepartmentController extends Controller
{
    public function index()
    {

        $departments = Department::all();

        return view('departments.index', compact('departments'));
    }



    public function create()
    {

//        $tickets = Ticket::all()->pluck('title', 'id')->prepend(trans('global.pleaseSelect'), '');

        $users = User::all()->pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        return view('departments.create', compact( 'users'));
    }

    public function store(Request $request)
    {
        $department = Department::create($request->all());

        return redirect()->route('departments.index');
    }

    public function edit(Department $department)
    {


        return view('departments.edit', compact('department'));
    }

    public function update(Request $request, Department $department)
    {
        $department->update($request->all());

        return redirect()->route('departments.index');
    }

    public function show(Department $department)
    {

        $department->load('ticket', 'user');

        return view('departments.show', compact('department'));
    }

    public function destroy(Department $department)
    {

        $department->delete();

        return back();
    }

    public function massDestroy(Request $request)
    {
        Department::whereIn('id', request('ids'))->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
