<?php

namespace App\Http\Controllers;

use App\Models\QuestionBank;
use App\Models\QuestionOptions;
use Illuminate\Http\Request;

class QuestionBankController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $questions = QuestionBank::all();
        return view('questions.update',['questions' => $questions]);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\QuestionBank  $questionBank
     * @return \Illuminate\Http\Response
     */
    public function show(QuestionBank $questionBank)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\QuestionBank  $questionBank
     * @return \Illuminate\Http\Response
     */
    public function edit(QuestionBank $questionBank)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\QuestionBank  $questionBank
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
         $input = $request->all();

        $questions =   $input['question'];
        $ids       =   $input['ids'];
        $status   =    $input['status'];
        $gender   =    $input['gender'];
        $q_order   =    $input['q_order'];
        $i = 0;

        foreach ($questions as $question) {

            // Question ID
            $id = $ids[$i];

            $bank = QuestionBank::where('id', $id)->first();

            $bank->status = $status[$i];
            $bank->gender = $gender[$i];
            $bank->q_order = $q_order[$i];
            $bank->question = $question;

            $bank->save();
            $bank->refresh();

            // Question Options

            if (isset($input['option_' . $id])) {

                $options = $input['option_' . $id];

                foreach ($options as $option) {

                    $detail = new QuestionOptions();

                    $detail->question_id = $id;
                    $detail->option = $option;

                    $detail->save();
                }

            }
            $i++;
            $bank = null;
        }

        return redirect()->route('questions.index')->with('updated','Updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\QuestionBank  $questionBank
     * @return \Illuminate\Http\Response
     */
    public function destroy(QuestionBank $questionBank)
    {
        //
    }
}
