<?php

namespace App\Http\Controllers;

use App\Models\Scheme;
use App\Models\SchemeDetails;
use Doctrine\DBAL\Exception;
use Illuminate\Http\Request;

class SchemeController extends Controller
{
/**
 * Display a listing of the resource.
 *
 * @return \Illuminate\Http\Response
 */
public function index()
{
    return view('schemes.index');
}

/**
 * Show the form for creating a new resource.
 *
 * @return \Illuminate\Http\Response
 */
public function create()
{
    return view('schemes.create');
}

/**
 * Store a newly created resource in storage.
 *
 * @param  \Illuminate\Http\Request  $request
 * @return \Illuminate\Http\Response
 */
public function store(Request $request, Scheme $scheme)
{
//        dd($request->all());

    $request->validate([
        'latitiude' => 'Scheme location marker is required.'
    ]);


    $names = $request->input('names');
    $sizes = $request->input('sizes');

    $set = array();
//
//    foreach($sizes as $index => $size){
//
//        if(isset($size)){
//
//            $set[$names[$index]] = $size;
//
//        }
//    }
//
//    foreach($set as $key => $value){
//
//        if(array_key_exists($key,array_flip($request->input('size_id')))) {
//
//            continue;
//        }
//        else{
//
//            return redirect()->back()->with('missing','Missing Plot Type Allocations.');
//        }
//    }


    $created = $scheme->create($request->all());

     $auction = $request->input('total_auction');
    $sizes = $request->input('size_id');

    $quota_category = $request->input('category');

    $i = 0;
//    if($created->scheme_type != 'building') {

        foreach ($request->input('size_id') as $size) {

            $details = new SchemeDetails();

            $details->scheme_id = $created->id;

            $details->quota_amount = $auction[$i];
            $details->size_id = $sizes[$i];
            $details->quota_category = $quota_category[$i];
            $details->quota_percentage = ( $auction[$i] / $request->total_plots) * 100 ;
            $details->save();

            $i++;

        }
//    }

    return redirect()->route('schemes.index')->with('created', 'Created Successfully.');
}

/**
 * Display the specified resource.
 *
 * @param  \App\Models\Scheme  $scheme
 * @return \Illuminate\Http\Response
 */
public function show(Request $request)
{

    $scheme = SchemeDetails::where('scheme_id',$request->scheme_id)
        ->with('plot_size')
        ->get(['id','size_id']);

    $scheme = $scheme->unique('plot_size');

    return $scheme;
}

public function scheme_plot_categories(Request $request)
{
    try{
        $category = SchemeDetails::where('size_id',$request->plot_size)
            ->where('scheme_id',$request->scheme_id)
            ->with('category')
            ->get(['id','quota_category','quota_amount']);

        return $category;
    }
    catch (\Exception $exception){
        return $exception->getMessage();
    }
}

/**
 * Show the form for editing the specified resource.
 *
 * @param  \App\Models\Scheme  $scheme
 * @return \Illuminate\Http\Response
 */
public function edit(Scheme $scheme)
{
    return view('schemes.edit',compact('scheme'));
}

/**
 * Update the specified resource in storage.
 *
 * @param  \Illuminate\Http\Request  $request
 * @param  \App\Models\Scheme  $scheme
 * @return \Illuminate\Http\Response
 */
public function update(Request $request, Scheme $scheme)
{
      $scheme->update($request->all());


    $units = $request->input('total_units');
    $auction = $request->input('total_auction');
    $sizes = $request->input('size_id');

    $quota_category = $request->input('category');


    $i = 0;
//    if($scheme->scheme_type != 'building') {
        $scheme->quota()->delete();

        foreach ($request->input('size_id') as   $size) {


            $details = new SchemeDetails();

            $details->scheme_id = $scheme->id;
            $details->quota_amount = $auction[$i];
            $details->size_id = $sizes[$i];
            $details->quota_category = $quota_category[$i];
            $details->quota_percentage = ( $auction[$i] / $request->total_plots) * 100 ;
            $details->save();
            $i++;

        }
//    }


      return redirect()->route('schemes.index')->with('updated', 'Scheme updated');
}

/**
 * Remove the specified resource from storage.
 *
 * @param  \App\Models\Scheme  $scheme
 * @return \Illuminate\Http\Response
 */
public function destroy(Scheme $scheme)
{
    //
}
}
