<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    public function salaries()
    {
        return $this->hasMany(Salary::class);
    }

    public function payslips()
    {
        return $this->hasMany(Payslip::class);
    }


    public function allowances()
    {
        return $this->hasMany(UserAllowance::class, 'employee_id');
    }


}
