<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Installments extends Model
{
    use HasFactory;

    protected $guarded = ['id'];


    public function plot()
    {

        return $this->belongsTo(PlotSizes::class, 'size_id');
    }

    public function scheme()
    {

        return $this->belongsTo(Scheme::class, 'scheme_id');
    }


    public function category()
    {

        return $this->belongsTo(PlotCategories::class, 'category_id');
    }
    public function details()
    {

        return $this->hasMany(InstallmentDetail::class, 'installment_id', 'id');
    }
}
