@extends('layouts.admin_layout')
@section('content')
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">

    <style>
        .form-control1 {
            width: 100% !important;

            border-color: #bdbdbd !important;
            border-radius: 0.3rem !important;
            box-shadow: none !important;
            transition: border-color 0.2s ease-in-out !important;
            height: 39px;
            padding: 5px;
        }

        .form-control1:focus {
            border-color: #66afe9 !important;
            /* Custom focus border color */
            box-shadow: 0 0 0 0.2rem rgba(102, 175, 233, 0.25) !important;
            /* Custom focus shadow */
        }

        .form-check-input1 {
            width: 1.5rem !important;
            /* Custom size */
            height: 1.5rem !important;
            /* Custom size */
            /* border-color: #bdbdbd !important; */
            /* Custom border color */
            border-radius: 0.25rem !important;
            /* Custom border radius */
            transition: background-color 0.2s ease-in-out, border-color 0.2s ease-in-out !important;
            /* Smooth transition */
        }

        .form-check-input1:checked {
            background-color: #66afe9 !important;
            /* Custom background color when checked */
            border-color: #66afe9 !important;
            /* Custom border color when checked */
        }

        .form-check-input1:focus {
            box-shadow: 0 0 0 0.2rem rgba(102, 175, 233, 0.25) !important;
            /* Custom focus shadow */
        }

        .form-check-label1 {
            margin-bottom: 0 !important;
            /* Remove default margin-bottom */
        }

        .form-check1 {
            margin-right: 1rem !important;
            /* Space between checkboxes */
        }
    </style>
    <div class="container-fluid">
        <form method="post" name="frm_presets" action="{{ route('allotments.store') }}" id="demo-form1" class="form-inline "
            novalidate enctype="multipart/form-data">
            @csrf
            <legend class="card-text card-header bg-white shadow-sm mb-4 row mb-3 p-3">Allotment Details: <span
                    id="schemeerror"></span>
                <div class="form-group col-md-4 mb-4" style="float:right">
                    <label class="">Scheme <span class="required">*</span></label>
                    <select class="form-select" id="scheme_id" name="scheme_id" required onchange="bind_scheme_plots();">
                        <option>--Select Scheme--</option>
                        @foreach (\App\Models\Scheme::all() as $scheme)
                            <option value="{{ $scheme->id }}">{{ $scheme->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group col-md-4 mb-4" style="float:right">
                    <label class="">Plot Size <span class="required">*</span></label>
                    <select class="form-select" onchange="bind_categories();" id="plot_size" name="size_id" required>
                        <option>--Select Plot Size--</option>
                        <?php foreach(\App\Models\PlotSizes::all() as $package){ ?>
                        <option value="{{ $package->id }}">{{ $package->name }}</option>
                        <?php } ?>
                    </select>
                </div>
                <div class="form-group col-md-4 mb-4" style="float:right">
                    <label class="">Quota Category <span class="required">*</span></label>
                    <select class="form-select " id="cat_id" name="quota_category" required></select>
                </div>
            </legend>
            <div class="row card-body shadow-sm bg-white"> @php $row = array(); @endphp
                <div class="col-md-12">
                    <div class="row mt-5">
                        <div class="col-md-2 mb-3">
                            <label for="application_no" class="form-label">Application No <span
                                    class="text-danger">*</span></label>
                            <input type="text" id="application_no" name="application_no"
                                class="form-control1 form-control" value="01" required
                                onblur="check_scheme_selection()">
                        </div>

                        <div class="col-md-2 mb-3">
                            Title <span class="required">*</span><br>
                            <select id="title" name="title" required class="form-select ">
                                <option value="Mr" selected>Mr</option>
                                <option value="Mrs">Mrs</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            Applicant Name <span class="required">*</span><br>
                            <input type="text" id="applicant_name" name="applicant_name" required
                                class="form-control1 form-control " value="abc" />
                        </div>
                        <div class="col-md-4 mb-3">
                            Father / Spouse Name <span class="required">*</span><br>
                            <input type="text" id="father_name" name="father_name" required
                                class="form-control1 form-control" value="def" />
                        </div>
                    </div>
                    <div class="row">
                        <div class=" form-group col-md-6">
                            CNIC # <span class="required">*</span><span id="cnicerror"></span><br>
                            <input type="text" id="cnic" name="cnic" maxlength="15" onBlur="check_cnic()"
                                required class="form-control1" value="1823452345234" />
                        </div>
                        <div class=" form-group col-md-6">
                            Date of Birth <span class="required">*</span><br>
                            <input type="date" id="dob" name="dob" required class="form-control1 form-control"
                                value="{{ date('Y-m-d') }}" />
                        </div>
                    </div>
                    <div class="row my-4">
                        <div class=" form-group col-md-4 ">
                            Contact Number 1 <span class="required">*</span><br>
                            <input type="text" id="contact_1" name="contact_1" required
                                class="form-control1 form-control" value="street 3" />
                        </div>
                        <div class=" form-group col-md-4">
                            Contact Number 2 <span class="required">*</span><br>
                            <input type="text" id="contact_2" name="contact_2" required
                                class="form-control1 form-control" value="02329329" />
                        </div>
                        <div class=" form-group col-md-4">
                            Email <br>
                            <input type="text" id="email" name="email" class="form-control1 form-control "
                                value="email@email.com" />
                        </div>
                    </div>
                    <div class="row mb-4">
                        <br>
                        <div class="form-group col-md-6">
                            Postal Address <span class="required">*</span><br>
                            <textarea id="postal_address" name="postal_address" required class="form-control1 form-control">street 1</textarea>
                        </div>
                        <div class="form-group col-md-6">
                            Permanent Address <span class="required">*</span><br>
                            <textarea id="permanent_address" name="permanent_address" required class="form-control1 form-control">street 2</textarea>
                        </div>
                    </div>
                    <div class="row  mb-4">
                        <fieldset>
                            <legend>Occupation / Nomination Details:</legend>
                        </fieldset>
                        <div class="form-group col-md-4"> Status of Occupation: <span class="required">*</span><br>
                            <select class="form-select" id="occupation_id" name="occupation_id" required="">
                                <option>--Select Occupation--</option>
                                <option value="1">Government Service</option>
                                <option value="2">Private Service</option>
                                <option value="3">Business</option>
                                <option value="4">Others</option>
                                <option value="5">House Wife</option>
                                <option value="6">Self Employed</option>
                                <option value="7">Other </option>
                            </select>
                        </div>
                        <div class=" form-group col-md-4">
                            <label for=""> Name of Employeer: <span class="required">*</span>
                            </label>
                            <input type="text" id="employer_name" name="employer_name" required
                                class="form-control1 form-control" value="employer" />
                        </div>
                        <div class=" form-group col-md-4">
                            <label for=""> Name of Nominee <span class="required">*</span></label>
                            <input type="text" id="nominee_name" name="nominee_name" required
                                class="form-control1 form-control" value="nominee" />
                        </div>
                    </div>
                    <div class="row mb-4">
                        <div class=" form-group col-md-6">
                            Nominee Contact <span class="required">*</span><br>
                            <input type="text" id="nominee_contact" name="nominee_contact" required
                                class="form-control1 form-control" value="234675" />
                        </div>
                        <div class=" form-group col-md-6">
                            Relationship <span class="required">*</span><br>
                            <input type="text" id="nominee_relation" name="nominee_relation" required
                                class="form-control1 form-control" value="friend" />
                        </div>
                        <div class=" form-group col-md-6">
                            Father / Spouse Name <span class="required">*</span><br>
                            <input type="text" id="nominee_father_name" name="nominee_father_name" required
                                class="form-control1 form-control" value="abc" />
                        </div>
                        <div class=" form-group col-md-6">
                            CNIC # <span class="required">*</span><br>
                            <input type="text" id="nominee_cnic" name="nominee_cnic" maxlength="15" required
                                class="form-control1 form-control" value="1234425456325" />
                        </div>
                    </div>
                    <div class="row mb-4">
                        <fieldset>
                            <legend>Allotment Details:</legend>
                        </fieldset>
                        <div class=" form-group col-md-3">
                            <label for=""> Allotment Order No: <span class="required">*</span><br>
                            </label>
                            <input type="text" id="allotment_order_no" name="allotment_order_no" required
                                class="form-control1 form-controls" value="01-ABC" />
                        </div>
                        <div class=" form-group col-md-3">
                            Date of Allotment <span class="required">*</span><br>
                            <input type="date" id="date_allotment" name="date_allotment" required
                                class="form-control1 form-control" value="<?php echo isset($row['date_allotment']) ? $row['date_allotment'] : ''; ?>" />
                        </div>
                        <div class=" form-group col-md-3">
                            <label for=""> Plot No / Flat No <span class="required">*</span> <span
                                    id="plotnoerror"></span>
                            </label>
                            <input type="text" id="plot_no" name="plot_no" required
                                class="form-control1 form-control" value="123" />
                        </div>
                        <div class=" form-group col-md-3">
                            <label for=""> Street # / Floor #
                                <span class="required">*</span>
                            </label>
                            <input class="form-control1 form-control" type="text" name="street_floor" required>
                        </div>
                    </div>
                    <div class="row mb-4">
                        <div class="form-check col-md-4">
                            <label class="form-check-label p-5" for="applied_refund">
                                Applied Refund
                            </label>

                            <input type="checkbox" id="applied_refund" value="yes" name="applied_refund"
                                class="form-check-input" />
                        </div>
                        <div class="form-group col-md-4">
                            <label class="form-check-label p-5" for="refunded">
                                Refunded </label>

                            <input type="checkbox" id="refunded" name="refunded" value="yes"
                                class="form-check-input" />
                        </div>
                        <div class="form-group col-md-4">
                            <label class="form-check-label p-5" for="cancled">
                                Cancelled </label>


                            <input type="checkbox" id="cancled" name="cancled" value="yes"
                                class="form-check-input" />
                        </div>
                    </div>
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class=" form-group">
                                <div class="col-md-12">
                                    Applicant Pic:<input name="applicant_image" class="form-control" type="file"
                                        id="image"><br>
                                </div>
                                <div class="col-md-12 mb-2 me-3 mb-3">ffse
                                    <img id="preview-image-before-upload" src=""
                                        style="max-height: 200px; max-width: 180px; ">
                                </div>
                                <div class="row col-md-12">
                                    <div class="ln_solid"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mb-4">
                        <div class="form-group" style="float:right;">
                            <div class="col-md-6 col-sm-6 col-xs-12 ">
                                <button type="submit" class="btn btn-success btn-lg ">Create
                                    Allotment</button>
                            </div>
                        </div>
                    </div>
                </div>
                <script>
                    function bind_scheme_plots() {
                        var request = $.ajax({
                            type: 'get',
                            url: '/schemes/plots/',
                            data: {
                                'scheme_id': $("#scheme_id :selected").val(),
                                '_token': '{{ csrf_token() }}'
                            },
                            async: true,
                        });
                        request.done(function(data) {
                            var plot = $("#plot_size")
                            plot.empty();
                            $.each(data, function(i, item) {
                                $('#plot_size').append($('<option>', {
                                    value: item.size_id,
                                    text: item.plot_size.name
                                }));
                            });

                            bind_categories();
                        });
                        request.fail(function(jqXHR, textStatus) {
                            console.log("Request failed: " + textStatus);
                            console.log("Request failed: " + jqXHR);
                        });

                    }

                    function bind_categories() {

                        $.ajax({
                            type: 'get',
                            url: '/schemes/plots/categories',
                            data: {
                                'scheme_id': $("#scheme_id :selected").val(),
                                'plot_size': $("#plot_size :selected").val(),
                                '_token': '{{ csrf_token() }}'
                            },
                            async: true,
                            success: function(data) {
                                var cat_id = $("#cat_id");
                                cat_id.empty();
                                console.log(data);
                                $.each(data, function(i, item) {
                                    $('#cat_id').append($('<option>', {
                                        value: item.quota_category,
                                        text: item.category.name + '(' + item.quota_amount + ')'
                                    }));
                                });
                            },
                            error: function(jqXHR, textStatus, errorThrown) {
                                console.log("Request failed: " + textStatus);
                                console.log("Error: " + errorThrown);
                                console.log("Response Text: " + jqXHR.responseText);
                            }
                        });
                    }
                </script>
                <script type="text/javascript">
                    $(document).ready(function(e) {
                        $('#image').change(function() {
                            let reader = new FileReader();
                            reader.onload = (e) => {
                                $('#preview-image-before-upload').attr('src', e.target.result);
                                $('#preview-image-before-upload').attr('height', 300);
                                $('#preview-image-before-upload').attr('width', 400);
                            }

                            reader.readAsDataURL(this.files[0]);

                        });

                    });
                </script>


            </div>
        </form>
    </div>
@endsection
