@extends('layouts.admin_layout')

@section('content')
    <style>
        input[type="text"],
        textarea {
            background-color: #f1f5f4;
            margin: 6px;
            padding: 17px;
            border: 1px solid rgba(193, 191, 191, 0.72) !important;
        }

        .row {
            margin-bottom: 25px;
        }

        input {
            padding: 1px;
        }

        input[type="text"] {
            border: 1px solid #ded9d9;
            height: 10px;
        }

        .col {
            margin: 20px;
            margin-bottom: 10px;
        }
    </style>

    <div class="container-fluid">
        <form method="post" name="frm_presets" action="{{ route('allotments.update', $allotment->id) }}" id="demo-form1"
            class="form-inline" novalidate enctype="multipart/form-data">
            @csrf
            @method('put')

            <legend class="card-text card-header bg-white shadow-sm mb-4 row mb-3">
                Allotment Details: <span id="schemeerror"></span>

                <div class="form-group col-md-3" style="float:right">
                    <label>Scheme <span class="required">*</span></label>
                    <select class="form-control" id="scheme_id" name="scheme_id" required onchange="bindSchemePlots();"
                        style="width:200px">
                        <option value="">--Select Scheme--</option>
                        @foreach (\App\Models\Scheme::all() as $scheme)
                            <option value="{{ $scheme->id }}"
                                {{ $allotment->scheme_id == $scheme->id ? 'selected' : '' }}>
                                {{ $scheme->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </legend>

            <div class="form-group col-md-3" style="float:right">
                <label>Plot Size <span class="required">*</span></label>
                <select class="form-control" id="plot_size" name="size_id" required onchange="bindCategories();"
                    style="width:200px">
                    <option value="">--Select Plot Size--</option>
                    @foreach (\App\Models\PlotSizes::all() as $package)
                        <option value="{{ $package->id }}">{{ $package->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="form-group col-md-4" style="float:right">
                <label>Quota Category <span class="required">*</span></label>
                <select class="form-control col-md-4" id="cat_id" name="cat_id" required></select>
            </div>

            <div class="row card-body shadow-sm bg-white">
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="form-group col-md-3">
                                <label>Application no <span class="required">*</span></label>
                                <input type="text" id="application_no" name="application_no"
                                    onBlur="checkSchemeSelection()" required class="form-control" value="01" />
                            </div>
                            <div class="form-group col-md-1">
                                <label>Title <span class="required">*</span></label>
                                <select id="title" name="title" required class="form-control">
                                    <option value="Mr" {{ $allotment->title == 'Mr' ? 'selected' : '' }}>Mr</option>
                                    <option value="Mrs" {{ $allotment->title == 'Mrs' ? 'selected' : '' }}>Mrs</option>
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label>Applicant Name <span class="required">*</span></label>
                                <input type="text" id="applicant_name" name="applicant_name" required
                                    class="form-control col-md-8 col-xs-12" value="{{ $allotment->applicant_name }}" />
                            </div>
                            <div class="form-group col-md-4">
                                <label>Father / Spouse Name <span class="required">*</span></label>
                                <input type="text" id="father_name" name="father_name" required
                                    class="form-control col-md-7 col-xs-12" value="{{ $allotment->father_name }}" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-3">
                                <label>CNIC # <span class="required">*</span><span id="cnicerror"></span></label>
                                <input type="text" id="cnic" name="cnic" maxlength="15" onBlur="checkCnic()"
                                    required class="form-control" value="{{ $allotment->cnic }}" />
                            </div>
                            <div class="form-group col-md-3">
                                <label>Date of Birth <span class="required">*</span></label>
                                <input type="date" id="dob" name="dob" required class="form-control"
                                    value="{{ $allotment->dob }}" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-3">
                                <label>Contact Number 1 <span class="required">*</span></label>
                                <input type="text" id="contact_1" name="contact_1" required
                                    class="form-control col-md-7 col-xs-12" value="{{ $allotment->contact_1 }}" />
                            </div>
                            <div class="form-group col-md-3">
                                <label>Contact Number 2 <span class="required">*</span></label>
                                <input type="text" id="contact_2" name="contact_2" required
                                    class="form-control col-md-7 col-xs-12" value="{{ $allotment->contact_2 }}" />
                            </div>
                            <div class="form-group col-md-3">
                                <label>Email</label>
                                <input type="email" id="email" name="email"
                                    class="form-control col-md-7 col-xs-12" value="{{ $allotment->email }}" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-4">
                                <label>Postal Address <span class="required">*</span></label>
                                <textarea id="postal_address" name="postal_address" style="width:100%" required
                                    class="form-control col-md-7 col-xs-12">{{ $allotment->postal_address }}</textarea>
                            </div>
                            <div class="form-group col-md-5">
                                <label>Permanent Address <span class="required">*</span></label>
                                <textarea id="permanent_address" name="permanent_address" style="width:100%" required
                                    class="form-control col-md-7 col-xs-12">{{ $allotment->permanent_address }}</textarea>
                            </div>
                        </div>

                        <div class="row">
                            <fieldset>
                                <legend>Occupation / Nomination Details:</legend>
                            </fieldset>
                            <div class="form-group col-md-4">
                                <label>Status of Occupation: <span class="required">*</span></label>
                                <select class="form-control" id="occupation_id" name="occupation_id" required>
                                    <option value="">-- Select Occupation --</option>
                                    <option value="1" {{ $allotment->occupation_id == 1 ? 'selected' : '' }}>
                                        Government Service</option>
                                    <option value="2" {{ $allotment->occupation_id == 2 ? 'selected' : '' }}>Private
                                        Service</option>
                                    <option value="3" {{ $allotment->occupation_id == 3 ? 'selected' : '' }}>Business
                                    </option>
                                    <option value="4" {{ $allotment->occupation_id == 4 ? 'selected' : '' }}>Others
                                    </option>
                                    <option value="5" {{ $allotment->occupation_id == 5 ? 'selected' : '' }}>House
                                        Wife</option>
                                    <option value="6" {{ $allotment->occupation_id == 6 ? 'selected' : '' }}>Self
                                        Employed</option>
                                    <option value="7" {{ $allotment->occupation_id == 7 ? 'selected' : '' }}>Other
                                    </option>
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label>Name of Employer: <span class="required">*</span></label>
                                <input type="text" id="employer_name" name="employer_name" required
                                    class="form-control col-md-7 col-xs-12" value="{{ $allotment->employer_name }}" />
                            </div>
                            <div class="form-group col-md-4">
                                <label>Name of Nominee <span class="required">*</span></label>
                                <input type="text" id="nominee_name" name="nominee_name" required
                                    class="form-control col-md-7 col-xs-12" value="{{ $allotment->nominee_name }}" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-4">
                                <label>Relation with Applicant <span class="required">*</span></label>
                                <input type="text" id="relation_with_applicant" name="relation_with_applicant"
                                    required class="form-control col-md-7 col-xs-12"
                                    value="{{ $allotment->relation_with_applicant }}" />
                            </div>
                            <div class="form-group col-md-4">
                                <label>Nominee's CNIC <span class="required">*</span></label>
                                <input type="text" id="nominee_cnic" name="nominee_cnic" required
                                    class="form-control col-md-7 col-xs-12" value="{{ $allotment->nominee_cnic }}" />
                            </div>
                            <div class="form-group col-md-4">
                                <label>Nominee's Contact Number <span class="required">*</span></label>
                                <input type="text" id="nominee_contact" name="nominee_contact" required
                                    class="form-control col-md-7 col-xs-12" value="{{ $allotment->nominee_contact }}" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row card-body shadow-sm bg-white">
                <div class="form-group col-md-3">
                    <label>Price <span class="required">*</span></label>
                    <input type="text" id="price" name="price" required class="form-control"
                        value="{{ $allotment->price }}" />
                </div>
                <div class="form-group col-md-3">
                    <label>Discount</label>
                    <input type="text" id="discount" name="discount" class="form-control"
                        value="{{ $allotment->discount }}" />
                </div>
                <div class="form-group col-md-3">
                    <label>Total Price</label>
                    <input type="text" id="total_price" name="total_price" class="form-control"
                        value="{{ $allotment->total_price }}" readonly />
                </div>
            </div>

            <div class="row card-body shadow-sm bg-white">
                <fieldset>
                    <legend>Payment Details:</legend>
                </fieldset>
                <div class="form-group col-md-3">
                    <label>Down Payment <span class="required">*</span></label>
                    <input type="text" id="down_payment" name="down_payment" required class="form-control"
                        value="{{ $allotment->down_payment }}" />
                </div>
                <div class="form-group col-md-3">
                    <label>Installments <span class="required">*</span></label>
                    <input type="text" id="installments" name="installments" required class="form-control"
                        value="{{ $allotment->installments }}" />
                </div>
                <div class="form-group col-md-3">
                    <label>Installment Plan</label>
                    <input type="text" id="installment_plan" name="installment_plan" class="form-control"
                        value="{{ $allotment->installment_plan }}" />
                </div>
                <div class="form-group col-md-3">
                    <label>Plan Duration (Months) <span class="required">*</span></label>
                    <input type="text" id="plan_duration" name="plan_duration" required class="form-control"
                        value="{{ $allotment->plan_duration }}" />
                </div>
            </div>

            <div class="row card-body shadow-sm bg-white">
                <div class="form-group col-md-3">
                    <label>Booking Date <span class="required">*</span></label>
                    <input type="date" id="booking_date" name="booking_date" required class="form-control"
                        value="{{ $allotment->booking_date }}" />
                </div>
                <div class="form-group col-md-3">
                    <label>Possession Date</label>
                    <input type="date" id="possession_date" name="possession_date" class="form-control"
                        value="{{ $allotment->possession_date }}" />
                </div>
                <div class="form-group col-md-3">
                    <label>Remarks</label>
                    <textarea id="remarks" name="remarks" class="form-control">{{ $allotment->remarks }}</textarea>
                </div>
            </div>

            <div class="row card-body shadow-sm bg-white">
                <div class="col-md-12 text-right">
                    <button type="submit" class="btn btn-primary">Update Allotment</button>
                </div>
            </div>
        </form>
    </div>

    <script>
        function bindSchemePlots() {
            var schemeId = $('#scheme_id').val();
            if (schemeId) {
                // Fetch plots based on scheme
                $.ajax({
                    url: '/api/scheme/' + schemeId + '/plots',
                    type: 'GET',
                    success: function(data) {
                        $('#plot_size').empty();
                        $.each(data, function(key, value) {
                            $('#plot_size').append('<option value="' + value.id + '">' + value.size +
                                '</option>');
                        });
                    }
                });
            } else {
                $('#plot_size').empty().append('<option value="">--Select Plot Size--</option>');
            }
        }

        function bindCategories() {
            var plotSizeId = $('#plot_size').val();
            if (plotSizeId) {
                // Fetch categories based on plot size
                $.ajax({
                    url: '/api/plot-size/' + plotSizeId + '/categories',
                    type: 'GET',
                    success: function(data) {
                        $('#cat_id').empty();
                        $.each(data, function(key, value) {
                            $('#cat_id').append('<option value="' + value.id + '">' + value.name +
                                '</option>');
                        });
                    }
                });
            } else {
                $('#cat_id').empty().append('<option value="">--Select Category--</option>');
            }
        }

        function checkCnic() {
            var cnic = $('#cnic').val();
            if (cnic.length !== 15) {
                $('#cnicerror').text('Invalid CNIC length');
            } else {
                $('#cnicerror').text('');
            }
        }

        function checkSchemeSelection() {
            if ($('#scheme_id').val() === '') {
                $('#schemeerror').text('Please select a scheme');
            } else {
                $('#schemeerror').text('');
            }
        }
    </script>
@endsection
