
@extends('layouts.admin_layout')

@section('content')
    @php

    @endphp
    <style>
        .btn.disabled,
        .btn.disabled:focus,
        .btn.disabled:hover {
            pointer-events: none;
            opacity: 0.65;
            /* Adjust as needed */
        }

        .btn[disabled] {
            cursor: not-allowed;
        }
    </style>
    <div class="container-fluid w-100">
        <form method="post" action="{{ route('schemes.update', [1]) }}">
            @method('patch')
            @csrf

            @if (Session::has('updated'))
                <div class="alert alert-success alert-dismissible col-3 offset-4 mt-3 fade show" role="alert">
                    <strong>Updated!</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif

            @if (Session::has('alloted'))
                <div class="alert alert-success alert-dismissible col-3 offset-4 mt-3 fade show" role="alert">
                    <strong>{{ session('alloted') }}</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif

            <h3 class="display-5 bg-white shadow-sm m-2">Export Report</h3>

            <table class="table table-responsive table-hover bg-white w-100" id="table_allotment">
                <thead>
                    <tr>
                        <th>Scheme</th>
                        <th>App #</th>
                        <th>Quota / Plot</th>
                        <th>Name</th>
                        <th>DOB</th>
                        <th>NIC</th>
                        <th>Father</th>
                        <th>Email</th>
                        <th>Addresses</th>
                        <th>Contacts</th>
                        <th>Nominee</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($allotments as $allotment)
                        <tr>
                            <td>
                                <figure>
                                    @if ($allotment->getFirstMediaUrl('allotment'))
                                        <img src="{{ asset($allotment->getFirstMediaUrl('allotment')) }}"
                                            class="img-responsive img-circle shadow-sm"
                                            style="height: 102px; width: 104px;">
                                    @endif
                                    <figcaption class="font-weight-bold mx-auto mt-1 text-center">
                                        {{ $allotment->scheme ? $allotment->scheme->name : 'No scheme is selected' }}

                                    </figcaption>
                                </figure>
                            </td>
                            <td>{{ $allotment->application_no }}</td>
                            <td>
                                @if ($allotment->plot)
                                    {{ $allotment->plot->name ?? 'No plot is selected' }}

                                    <span class="badge badge-success m-2">{{ $allotment->size->name ?? '' }}</span>
                                @else
                                    {{ $allotment->plot->name ?? 'No plot is selected' }}
                                @endif
                            </td>
                            <td>{{ $allotment->applicant_name }}</td>
                            <td>{{ $allotment->dob }}</td>
                            <td>{{ $allotment->cnic }}</td>
                            <td>{{ $allotment->father_name }}</td>
                            <td>{{ $allotment->email }}</td>
                            <td>
                                @if ($allotment->postal_address)
                                    <span class="badge badge-success m-1">{{ $allotment->postal_address }}</span>
                                @endif
                                @if ($allotment->permanent_address)
                                    <span class="badge badge-success m-1">{{ $allotment->permanent_address }}</span>
                                @endif
                            </td>
                            <td>
                                @if ($allotment->contact_1)
                                    <span class="badge badge-secondary m-1">{{ $allotment->contact_1 }}</span>
                                @endif
                                @if ($allotment->contact_2)
                                    <span class="badge badge-secondary m-1">{{ $allotment->contact_2 }}</span>
                                @endif
                            </td>
                            <td>
                                @if ($allotment->nominee_name)
                                    <span class="badge badge-secondary m-1">Name - {{ $allotment->nominee_name }}</span>
                                @endif
                                @if ($allotment->nominee_contact)
                                    <span class="badge badge-secondary m-1">Contact -
                                        {{ $allotment->nominee_contact }}</span>
                                @endif
                                @if ($allotment->nominee_relation)
                                    <span class="badge badge-secondary m-1">Relation -
                                        {{ $allotment->nominee_relation }}</span>
                                @endif
                                @if ($allotment->nominee_father_name)
                                    <span class="badge badge-secondary m-1">Father Name -
                                        {{ $allotment->nominee_father_name }}</span>
                                @endif
                                @if ($allotment->nominee_cnic)
                                    <span class="badge badge-secondary m-1">CNIC - {{ $allotment->nominee_cnic }}</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('allotments.edit', $allotment->id) }}"
                                    class="btn btn-sm m-1 btn-outline-success">
                                    <span class="typcn typcn-pencil menu-icon"></span> Edit
                                </a>
                                <a href="{{ $allotment->plot ? route('installment.create', $allotment->id) : '#' }}"
                                    class="btn btn-sm m-1 btn-outline-secondary {{ !$allotment->plot ? 'disabled' : '' }}"
                                    {{ !$allotment->plot ? 'tabindex="-1" aria-disabled="true" title="Please select a category"' : '' }}>
                                    <span class="typcn typcn-chart-bar menu-icon"></span> Installments
                                </a>

                                <a href="{{ url('transfer/plot/' . $allotment->id) }}"
                                    class="btn btn-sm m-1 btn-outline-primary">
                                    <span class="typcn typcn-arrow-repeat menu-icon"></span> Transfers
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </form>

        <div class="d-flex justify-content-center">
            {{-- {{ $allotments->links() }} --}}
        </div>
    </div>

    <script>
        function add_option(id) {
            var start = '<div class="col-auto input-group-append mt-2">';
            var option =
                '<input type="text" class="form-control w-100" required style="width: auto !important;" name="option_' +
                id + '[]">';
            var button =
                '<button class="btn btn-sm btn-outline-warning btn-icon-append" onclick="delete_option(this.id)"> ' +
                '<span class="mdi mdi-delete-outline"></span> </button>';
            var end = '</div>';
            var stringed = start + option + button + end;
            $("#unique_" + id).append(stringed);
        }
    </script>

    <script>
        $(document).ready(function() {
            $('#table_allotment').DataTable({
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'print',
                    {
                        extend: 'pdfHtml5',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 5, 6, 8, 9]
                        },
                        text: 'Save as PDF',
                    }
                ]
            });
        });
    </script>
@endsection
