@extends('layouts.admin_layout')
@section('content')
{{--    @permission('comment_create')--}}
        <div style="margin-bottom: 10px;" class="row">
            <div class="col-lg-12">
                <a class="btn btn-success" type="button" href="{{ route("admin.contracts.create") }}">
                    {{ trans('global.add') }} {{ trans('cruds.contracts.title_singular') }}
                </a>
            </div>
        </div>
{{--    @endpermission--}}
    <div class="card">
        <div class="card-header">
            {{ trans('cruds.contracts.title_singular') }} {{ trans('global.list') }}
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class=" table table-bordered table-striped table-hover datatable datatable-Comment">
                    <thead>
                    <tr>
                        <th width="10">

                        </th>
                        <th >
                            {{ trans('cruds.contracts.fields.id') }}
                        </th>
                        <th>
                            {{ trans('cruds.contracts.fields.contract_title') }}

                        </th>
                        <th>
                            {{ trans('cruds.contracts.fields.price') }}

                        </th>
                        <th>
                            {{ trans('cruds.contracts.fields.alert_days') }}

                        </th>
                        <th>
                            {{ trans('cruds.contracts.fields.company') }}

                        </th>

                        <th>
                            {{ trans('cruds.contracts.fields.start_at') }}
                        </th>
                        <th>
                            {{ trans('cruds.contracts.fields.end_at') }}
                        </th>
                        <th>
                            {{ trans('cruds.contracts.fields.status') }}
                        </th>
                        <th>
                            {{ trans('cruds.contracts.fields.details') }}
                        </th>
                        <th>
                            {{ trans('global.action') }}

                        </th>
{{--                        <th>--}}
{{--                            {{trans('cruds.contracts.fields.attatchments')}}--}}
{{--                        </th>--}}
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($contracts as $key => $contract)
                        <tr data-entry-id="{{ $contract->id }}">
                            <td>

                            </td>
                            <td>
                                {{ $contract->id ?? '' }}
                            </td>
                            <td>
                                {{ $contract->title ?? '' }}
                            </td>
                            <td>
                                {{ $contract->price ?? '' }}
                            </td>
                            <td>
                                {{ $contract->expiry_alert_days ?? '' }}
                            </td>
                            <td>
                                {{ $contract->company->company ?? '' }}
                            </td>
                            <td>
                                {{ date('Y-M-d ',strtotime($contract->start_at)) ?? '' }}
                            </td>
                            <td>
                                {{ date('Y-M-d ',strtotime($contract->end_at)) ?? '' }}

                            </td>
                            <td>
                                {{
                            trans('cruds.contracts.status.'.$contract->status)
                                }}
                            </td>
                            <td>
                                {{ $contract->details ?? '' }}
                            </td>
                            <td>
                                {{--                                @permission('comment_show')--}}
                                {{--                                    <a class="btn btn-xs btn-primary" href="{{ route('admin.contracts.show', $contract->id) }}">--}}
                                {{--                                        {{ trans('global.view') }}--}}
                                {{--                                    </a>--}}
                                {{--                                @endpermission--}}

                                @permission('commentedit')
                                    <a class="btn btn-xs btn-info" href="{{ route('admin.contracts.edit', $contract->id) }}">
                                        {{ trans('global.edit') }}
                                    </a>
                                @endpermission

                                @permission('commentdelete')
                                    <form action="{{ route('admin.contracts.destroy', $contract->id) }}" method="POST" onsubmit="return confirm('{{ trans('global.areYouSure') }}');" style="display: inline-block;">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        <input type="submit" class="btn btn-xs btn-danger" value="{{ trans('global.delete') }}">
                                    </form>
                                @endpermission

                            </td>

{{--                            <td>--}}
{{--                                @foreach($contract->attachments as $attachment)--}}
{{--                                    <a href="{{ route('get_files',['mediaItem'=> $attachment]) }}" target="_blank">{{ $attachment->file_name }}</a>--}}
{{--                                @endforeach--}}
{{--                            </td>--}}


                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>


        </div>
    </div>
@endsection
@section('scripts')
    @parent
    <script>
        $(function () {
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
                @permission('commentdelete')
            let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "{{ route('admin.comments.massDestroy') }}",
                className: 'btn-danger',
                action: function (e, dt, node, config) {
                    var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
                        return $(entry).data('entry-id')
                    });

                    if (ids.length === 0) {
                        alert('{{ trans('global.datatables.zero_selected') }}')

                        return
                    }

                    if (confirm('{{ trans('global.areYouSure') }}')) {
                        $.ajax({
                            headers: {'x-csrf-token': _token},
                            method: 'POST',
                            url: config.url,
                            data: { ids: ids, _method: 'DELETE' }})
                            .done(function () { location.reload() })
                    }
                }
            }
            dtButtons.push(deleteButton)
            @endpermission

            $.extend(true, $.fn.dataTable.defaults, {
                order: [[ 1, 'desc' ]],
                pageLength: 100,
            });
            $('.datatable-Comment:not(.ajaxTable)').DataTable({ buttons: dtButtons })
            $('a[data-toggle="tab"]').on('shown.bs.tab', function(e){
                $($.fn.dataTable.tables(true)).DataTable()
                    .columns.adjust();
            });
        })

    </script>
@endsection
