@extends('layouts.admin_layout')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.company.title_singular') }}
    </div>

    <div class="card-body">
        <form action="{{ route("admin.departments.update", [$department->id]) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="form-group {{ $errors->has('author_name') ? 'has-error' : '' }}">
                <label for="company">{{ trans('cruds.comment.fields.author_name') }}*</label>

                <input type="text" id="department" name="department" class="form-control" value="{{  $department->department }}" required>

               @if($errors->has('department'))
                    <em class="invalid-feedback">
                        {{ $errors->first('department') }}
                    </em>
                @endif

                <p class="helper-block">
                    {{ trans('cruds.comment.fields.author_name_helper') }}
                </p>

            </div>

            <div>
                <input class="btn btn-danger" type="submit" value="{{ trans('global.save') }}">
            </div>
        </form>


    </div>
</div>
@endsection
