@extends('layouts.admin_layout')
@section('content')

    <div class="card">
        <div class="card-header">
            Edit Employee
        </div>
        <style>
            .form-control1 {
                width: 100% !important;
                border-color: #bdbdbd !important;
                border-radius: 0.3rem !important;
                box-shadow: none !important;
                transition: border-color 0.2s ease-in-out !important;
                height: 39px;
                padding: 5px;
            }

            .form-control1:focus {
                border-color: #66afe9 !important;
                /* Custom focus border color */
                box-shadow: 0 0 0 0.2rem rgba(102, 175, 233, 0.25) !important;
                /* Custom focus shadow */
            }

            .form-check-input1 {
                width: 1.5rem !important;
                /* Custom size */
                height: 1.5rem !important;
                /* Custom size */
                /* border-color: #bdbdbd !important; */
                /* Custom border color */
                border-radius: 0.25rem !important;
                /* Custom border radius */
                transition: background-color 0.2s ease-in-out, border-color 0.2s ease-in-out !important;
                /* Smooth transition */
            }

            .form-check-input1:checked {
                background-color: #66afe9 !important;
                /* Custom background color when checked */
                border-color: #66afe9 !important;
                /* Custom border color when checked */
            }

            .form-check-input1:focus {
                box-shadow: 0 0 0 0.2rem rgba(102, 175, 233, 0.25) !important;
                /* Custom focus shadow */
            }

            .form-check-label1 {
                margin-bottom: 0 !important;
                /* Remove default margin-bottom */
            }

            .form-check1 {
                margin-right: 1rem !important;
                /* Space between checkboxes */
            }
        </style>

        <div class="card-body">
            @if (session('success'))
                <div class="alert alert-success" role="alert">
                    {{ session('success') }}
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger" role="alert">
                    {{ session('error') }}
                </div>
            @endif

            <form action="{{ route('admin.employees.update', $employee->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="form-group col-md-6">
                        <label for="name">Name*</label>
                        <input type="text" name="name" class="form-control1"
                            value="{{ old('name', $employee->name) }}" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="father_name">Father's Name*</label>
                        <input type="text" name="father_name" class="form-control1"
                            value="{{ old('father_name', $employee->father_name) }}" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="email">Email*</label>
                        <input type="email" name="email" class="form-control1"
                            value="{{ old('email', $employee->email) }}" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="position">Position*</label>
                        <input type="text" name="position" class="form-control1"
                            value="{{ old('position', $employee->position) }}" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="basic_salary">Basic Salary*</label>
                        <input type="number" name="basic_salary" class="form-control1"
                            value="{{ old('basic_salary', $employee->basic_salary) }}" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="appointment_date">Appointment Date*</label>
                        <input type="date" name="appointment_date" class="form-control1"
                            value="{{ old('appointment_date', $employee->appointment_date) }}" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="promotion_date">Promotion Date</label>
                        <input type="date" name="promotion_date" class="form-control1"
                            value="{{ old('promotion_date', $employee->promotion_date) }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="job_type">Job Type*</label>
                        <select name="job_type" class="form-control1">
                            <option value="full_time"
                                {{ old('job_type', $employee->job_type) == 'full_time' ? 'selected' : '' }}>Full Time
                            </option>
                            <option value="part_time"
                                {{ old('job_type', $employee->job_type) == 'part_time' ? 'selected' : '' }}>Part Time
                            </option>
                            <option value="contract"
                                {{ old('job_type', $employee->job_type) == 'contract' ? 'selected' : '' }}>Contract
                            </option>
                        </select>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="personal_number">Personal Number*</label>
                        <input type="text" name="personal_number" class="form-control"
                            value="{{ old('personal_number', $employee->personal_number) }}" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="leave_balance">Leave Balance</label>
                        <input type="number" name="leave_balance" class="form-control"
                            value="{{ old('leave_balance', $employee->leave_balance) }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="reporting_officer">Reporting Officer</label>
                        <input type="text" name="reporting_officer" class="form-control"
                            value="{{ old('reporting_officer', $employee->reporting_officer) }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="sick_leaves">Sick Leaves</label>
                        <input type="number" name="sick_leaves" class="form-control"
                            value="{{ old('sick_leaves', $employee->sick_leaves) }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="casual_leaves">Casual Leaves</label>
                        <input type="number" name="casual_leaves" class="form-control"
                            value="{{ old('casual_leaves', $employee->casual_leaves) }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="earned_leaves">Earned Leaves</label>
                        <input type="number" name="earned_leaves" class="form-control"
                            value="{{ old('earned_leaves', $employee->earned_leaves) }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="district_of_domicile">District of Domicile</label>
                        <input type="text" name="district_of_domicile" class="form-control"
                            value="{{ old('district_of_domicile', $employee->district_of_domicile) }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="marital_status">Marital Status</label>
                        <select name="marital_status" class="form-control1">
                            <option value="single"
                                {{ old('marital_status', $employee->marital_status) == 'single' ? 'selected' : '' }}>Single
                            </option>
                            <option value="married"
                                {{ old('marital_status', $employee->marital_status) == 'married' ? 'selected' : '' }}>
                                Married</option>
                        </select>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="date_of_birth">Date of Birth*</label>
                        <input type="date" name="date_of_birth" class="form-control1"
                            value="{{ old('date_of_birth', $employee->date_of_birth) }}" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="city_of_birth">City of Birth</label>
                        <input type="text" name="city_of_birth" class="form-control1"
                            value="{{ old('city_of_birth', $employee->city_of_birth) }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="date_of_marriage">Date of Marriage</label>
                        <input type="date" name="date_of_marriage" class="form-control1"
                            value="{{ old('date_of_marriage', $employee->date_of_marriage) }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="province_of_domicile">Province of Domicile</label>
                        <input type="text" name="province_of_domicile" class="form-control1"
                            value="{{ old('province_of_domicile', $employee->province_of_domicile) }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="no_of_dependents">Number of Dependents</label>
                        <input type="number" name="no_of_dependents" class="form-control1"
                            value="{{ old('no_of_dependents', $employee->no_of_dependents) }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="nationality">Nationality</label>
                        <input type="text" name="nationality" class="form-control1"
                            value="{{ old('nationality', $employee->nationality) }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="religion">Religion</label>
                        <input type="text" name="religion" class="form-control1"
                            value="{{ old('religion', $employee->religion) }}">
                    </div>
                </div>
                <button type="submit" class="btn btn-primary">Update</button>
            </form>


        </div>
    </div>
@endsection

@section('scripts')
@stop
