@extends('layouts.admin_layout')
@section('content')

    <div class="card">
        <div class="card-header">
            <div class="row ">
                <div class="col-md-10">
                    Employee List

                </div>
                <div class="col-md-2">
                    <a href="{{ route('admin.employees.create') }}" class="btn btn-primary">Create</a>
                </div>

            </div>
        </div>
        <style>
            .form-control1 {
                width: 100% !important;
                border-color: #bdbdbd !important;
                border-radius: 0.3rem !important;
                box-shadow: none !important;
                transition: border-color 0.2s ease-in-out !important;
                height: 39px;
                padding: 5px;
            }

            .form-control1:focus {
                border-color: #66afe9 !important;
                /* Custom focus border color */
                box-shadow: 0 0 0 0.2rem rgba(102, 175, 233, 0.25) !important;
                /* Custom focus shadow */
            }

            .form-check-input1 {
                width: 1.5rem !important;
                /* Custom size */
                height: 1.5rem !important;
                /* Custom size */
                /* border-color: #bdbdbd !important; */
                /* Custom border color */
                border-radius: 0.25rem !important;
                /* Custom border radius */
                transition: background-color 0.2s ease-in-out, border-color 0.2s ease-in-out !important;
                /* Smooth transition */
            }

            .form-check-input1:checked {
                background-color: #66afe9 !important;
                /* Custom background color when checked */
                border-color: #66afe9 !important;
                /* Custom border color when checked */
            }

            .form-check-input1:focus {
                box-shadow: 0 0 0 0.2rem rgba(102, 175, 233, 0.25) !important;
                /* Custom focus shadow */
            }

            .form-check-label1 {
                margin-bottom: 0 !important;
                /* Remove default margin-bottom */
            }

            .form-check1 {
                margin-right: 1rem !important;
                /* Space between checkboxes */
            }
        </style>

        <div class="card-body">

            @if (session('success'))
                <div class="alert alert-success" role="alert">
                    {{ session('success') }}
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger" role="alert">
                    {{ session('error') }}
                </div>
            @endif



            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Job Type</th>
                        <th>Present Post</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($employees as $employee)
                        <tr>
                            <td>{{ $employee->id }}</td>
                            <td>{{ $employee->name }}</td>
                            <td>{{ $employee->email }}</td>
                            <td>{{ ucfirst($employee->job_type) }}</td>
                            <td>{{ $employee->present_post }}</td>
                            <td>
                                <a href="{{ route('admin.employees.show', $employee->id) }}"
                                    class="btn btn-primary btn-sm">View</a>
                                <a href="{{ route('admin.employees.edit', $employee->id) }}"
                                    class="btn btn-warning btn-sm">Edit</a>
                                <form action="{{ route('admin.employees.destroy', $employee->id) }}" method="POST"
                                    style="display:inline-block;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm"
                                        onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                                <a
                                    href="{{ route('admin.payslip.show', ['employeeId' => $employee->id, 'month' => now()->format('Y-m')]) }}">
                                    View Payslip
                                </a>

                            </td>

                        </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>
@endsection

@section('scripts')
@stop
