@extends('layouts.admin_layout')
@section('content')

    <div class="card">
        <div class="card-header">
            Employee Details
        </div>
        <style>
            .form-control1 {
                width: 100% !important;
                border-color: #bdbdbd !important;
                border-radius: 0.3rem !important;
                box-shadow: none !important;
                transition: border-color 0.2s ease-in-out !important;
                height: 39px;
                padding: 5px;
            }

            .form-control1:focus {
                border-color: #66afe9 !important;
                /* Custom focus border color */
                box-shadow: 0 0 0 0.2rem rgba(102, 175, 233, 0.25) !important;
                /* Custom focus shadow */
            }

            .form-check-input1 {
                width: 1.5rem !important;
                /* Custom size */
                height: 1.5rem !important;
                /* Custom size */
                /* border-color: #bdbdbd !important; */
                /* Custom border color */
                border-radius: 0.25rem !important;
                /* Custom border radius */
                transition: background-color 0.2s ease-in-out, border-color 0.2s ease-in-out !important;
                /* Smooth transition */
            }

            .form-check-input1:checked {
                background-color: #66afe9 !important;
                /* Custom background color when checked */
                border-color: #66afe9 !important;
                /* Custom border color when checked */
            }

            .form-check-input1:focus {
                box-shadow: 0 0 0 0.2rem rgba(102, 175, 233, 0.25) !important;
                /* Custom focus shadow */
            }

            .form-check-label1 {
                margin-bottom: 0 !important;
                /* Remove default margin-bottom */
            }

            .form-check1 {
                margin-right: 1rem !important;
                /* Space between checkboxes */
            }
        </style>

        <div class="card-body">
            @if (session('success'))
                <div class="alert alert-success" role="alert">
                    {{ session('success') }}
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger" role="alert">
                    {{ session('error') }}
                </div>
            @endif

            <table class="table table-bordered">
                <tr>
                    <th>Name</th>
                    <td>{{ $employee->name }}</td>
                </tr>
                <tr>
                    <th>Father's Name</th>
                    <td>{{ $employee->father_name }}</td>
                </tr>
                <tr>
                    <th>Email</th>
                    <td>{{ $employee->email }}</td>
                </tr>
                <tr>
                    <th>Position</th>
                    <td>{{ $employee->position }}</td>
                </tr>
                <tr>
                    <th>Basic Salary</th>
                    <td>{{ $employee->basic_salary }}</td>
                </tr>
                <tr>
                    <th>Appointment Date</th>
                    <td>{{ $employee->appointment_date }}</td>
                </tr>
                <tr>
                    <th>Promotion Date</th>
                    <td>{{ $employee->promotion_date }}</td>
                </tr>
                <tr>
                    <th>Job Type</th>
                    <td>{{ $employee->job_type }}</td>
                </tr>
                <tr>
                    <th>Personal Number</th>
                    <td>{{ $employee->personal_number }}</td>
                </tr>
                <tr>
                    <th>Leave Balance</th>
                    <td>{{ $employee->leave_balance }}</td>
                </tr>
                <tr>
                    <th>Reporting Officer</th>
                    <td>{{ $employee->reporting_officer }}</td>
                </tr>
                <tr>
                    <th>Sick Leaves</th>
                    <td>{{ $employee->sick_leaves }}</td>
                </tr>
                <tr>
                    <th>Casual Leaves</th>
                    <td>{{ $employee->casual_leaves }}</td>
                </tr>
                <tr>
                    <th>Earned Leaves</th>
                    <td>{{ $employee->earned_leaves }}</td>
                </tr>
                <tr>
                    <th>District of Domicile</th>
                    <td>{{ $employee->district_of_domicile }}</td>
                </tr>
                <tr>
                    <th>Marital Status</th>
                    <td>{{ $employee->marital_status }}</td>
                </tr>
                <tr>
                    <th>Date of Birth</th>
                    <td>{{ $employee->date_of_birth }}</td>
                </tr>
                <tr>
                    <th>City of Birth</th>
                    <td>{{ $employee->city_of_birth }}</td>
                </tr>
                <tr>
                    <th>Date of Marriage</th>
                    <td>{{ $employee->date_of_marriage }}</td>
                </tr>
                <tr>
                    <th>Province of Domicile</th>
                    <td>{{ $employee->province_of_domicile }}</td>
                </tr>
                <tr>
                    <th>Number of Dependents</th>
                    <td>{{ $employee->no_of_dependents }}</td>
                </tr>
                <tr>
                    <th>Nationality</th>
                    <td>{{ $employee->nationality }}</td>
                </tr>
                <tr>
                    <th>Religion</th>
                    <td>{{ $employee->religion }}</td>
                </tr>
            </table>

        </div>
    </div>
@endsection

@section('scripts')
@stop
