{{-- @extends('layouts.admin_layout')

@section('content')
    <div class="container">
        <style>
            .item {
                margin-bottom: 10px !important;
            }
        </style>

        @if (\Session::has('created'))
            <span class="row mx-auto font-weight-bolder text-center mt-2 alert alert-success">
                {{ \session('created') }}
            </span>
        @endif

        <h3 class="bg-white card-header m-3"> Create Installment </h3>

        <form method="post" name="frm" action="{{ route('installments.store') }}" id="demo-form2"
            class="form-inline form-label-left p-3" enctype="multipart/form-data">
            @csrf
            <div class="row bg-white shadow-sm p-3">
                <div class="item form-group">
                    <label class="control-label col-md-4 col-sm-4 col-xs-6" for="first-name"> Scheme <span
                            class="required">*</span>
                    </label>
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <select class="form-control col-md-12 col-xs-6" id="scheme_id" name="scheme_id" required
                            onChange="">
                            <option> --Select Scheme-- </option>
                            @foreach (\App\Models\Scheme::all() as $scheme)
                                <option value="{{ $scheme->id }}"
                                    {{ isset($selected) && $selected->scheme_id == $scheme->id ? 'selected' : '' }}>
                                    {{ $scheme->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="item form-group">
                    <label class="control-label col-md-4 col-sm-4 col-xs-6" for="first-name"> &nbsp;&nbsp;&nbsp; Plot Size
                        <span class="required">*</span>
                    </label>
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <select class="form-control col-md-12 col-xs-6" id="size_id" name="size_id" required>
                            <option>--Select Plot Size--</option>
                            @foreach (\App\Models\PlotSizes::all() as $size)
                                { ?>
                                <option value="{{ $size->id }}"
                                    {{ isset($plot) && $plot->scheme_id == $size->id ? 'selected' : '' }}>
                                    {{ $size->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="item form-group">
                    <label class="control-label col-md-4 col-sm-4 col-xs-6" for="first-name"> &nbsp;&nbsp;&nbsp; Allotment
                        Category <span class="required">*</span>
                    </label>
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <select class="form-control col-md-12 col-xs-6" id="category_id" name="category_id" required>
                            <option>--Select Category --</option>
                            @foreach (\App\Models\PlotCategories::all() as $size)
                                <option value="{{ $size->id }}"
                                    {{ isset($plot) && $plot->scheme_id == $size->id ? 'selected' : '' }}>
                                    {{ $size->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-md-4 col-sm-4 col-xs-6">
                        Total Installments
                    </label>
                    <input type="number" class="form-control" name="total_installments">
                </div>

                <div class="d-flex m-4 justify-content-center">
                    <button class="btn btn-primary">
                        Create Installments
                    </button>

                </div>


                <div class="ln_solid"></div>
            </div>
        </form>

        <h2 class="bg-white card-header m-3"> Installments </h2>



        <form method="post" name="frm" action="" id="demo-form2" class="form-horizontal form-label-left"
            novalidate enctype="multipart/form-data">

            <div class="col-md-12">

                <table class="table table-hover table-responsive">

                    <tr>
                        <th style="border: 0;border-bottom: 2px;"> Serial #</th>
                        <th style="border: 0;border-bottom: 2px;"> Scheme </th>

                        <th style="border: 0;border-bottom: 2px;"> Plot Size </th>


                        <th style="border: 0;border-bottom: 2px;"> Category </th>

                        <th style="border: 0;border-bottom: 2px;"> Total installments </th>

                        <th class="text-center" style="border: 0;border-bottom: 2px;"> Define </th>
                    </tr>

                    <tbody class="table-body bg-white card-body">

                        @foreach (\App\Models\Installments::all() as $installment)
                            <tr>
                                <td> {{ $installment->id }} </td>
                                <td> {{ $installment->scheme->name }} </td>
                                <td> {{ $installment->plot->name }} </td>

                                <td> {{ $installment->category->name }} </td>
                                <td class="text-center"> {{ $installment->total_installments }} </td>

                                </td>

                                <td>
                                    <a href="{{ route('installmentdetail.edit', $installment->id) }}"
                                        class="btn btn-primary">
                                        Define
                                    </a>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>

            </div>
        </form>


    </div>
@endsection --}}

@extends('layouts.admin_layout')

@section('content')
    <div class="container">
        <style>
            .item {
                margin-bottom: 10px !important;
            }
        </style>

        @if (session()->has('created'))
            <span class="row mx-auto font-weight-bolder text-center mt-2 alert alert-success">
                {{ session('created') }}
            </span>
        @endif

        <h3 class="bg-white card-header m-3"> Create Installment </h3>

        <form method="POST" action="{{ route('installments.store') }}" id="demo-form2" class="form-inline form-label-left p-3"
            enctype="multipart/form-data">
            @csrf
            <div class="row bg-white shadow-sm p-3">
                <div class="item form-group">
                    <label class="control-label col-md-4 col-sm-4 col-xs-6" for="scheme_id"> Scheme <span
                            class="required">*</span></label>
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <select class="form-control col-md-12 col-xs-6" id="scheme_id" name="scheme_id" required>
                            <option value="">--Select Scheme--</option>
                            @foreach (\App\Models\Scheme::all() as $scheme)
                                <option value="{{ $scheme->id }}"
                                    {{ isset($selected) && $selected->scheme_id == $scheme->id ? 'selected' : '' }}>
                                    {{ $scheme->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="item form-group">
                    <label class="control-label col-md-4 col-sm-4 col-xs-6" for="size_id"> Plot Size <span
                            class="required">*</span></label>
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <select class="form-control col-md-12 col-xs-6" id="size_id" name="size_id" required>
                            <option value="">--Select Plot Size--</option>
                            @foreach (\App\Models\PlotSizes::all() as $size)
                                <option value="{{ $size->id }}"
                                    {{ isset($plot) && $plot->size_id == $size->id ? 'selected' : '' }}>
                                    {{ $size->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="item form-group">
                    <label class="control-label col-md-4 col-sm-4 col-xs-6" for="category_id"> Allotment Category <span
                            class="required">*</span></label>
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <select class="form-control col-md-12 col-xs-6" id="category_id" name="category_id" required>
                            <option value="">--Select Category--</option>
                            @foreach (\App\Models\PlotCategories::all() as $category)
                                <option value="{{ $category->id }}"
                                    {{ isset($plot) && $plot->category_id == $category->id ? 'selected' : '' }}>
                                    {{ $category->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-md-4 col-sm-4 col-xs-6" for="total_installments"> Total Installments
                        <span class="required">*</span></label>
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <input type="number" class="form-control" name="total_installments" required>
                    </div>
                </div>

                <div class="d-flex m-4 justify-content-center">
                    <button type="submit" class="btn btn-primary">Create Installments</button>
                </div>

                <div class="ln_solid"></div>
            </div>
        </form>

        <h2 class="bg-white card-header m-3"> Installments </h2>

        <div class="col-md-12">
            <div class="card">
                <table class="table table-hover table-responsive">
                    <thead>
                        <tr>
                            <th style="width: 10%;">Serial #</th>
                            <th style="width: 10%;">Scheme</th>
                            <th style="width: 10%;">Plot Size</th>
                            <th style="width: 10%;">Category</th>
                            <th class="text-center" style="width: 10%;">Total Installments</th>
                            <th class="text-center" style="width: 10%;">Define</th>
                        </tr>
                    </thead>
                    <tbody class="table-body bg-white card-body">
                        @foreach ($installments as $installment)
                            <tr>
                                <td>{{ $installment->id }}</td>
                                <td>{{ $installment->scheme->name }}</td>
                                <td>{{ $installment->plot->name }}</td>
                                <td>{{ $installment->category ? $installment->category->name : 'No category is selected' }}
                                </td>
                                <td class="text-center">{{ $installment->total_installments }}</td>
                                <td class="text-center">
                                    <a href="{{ route('installmentdetail.edit', $installment->id) }}"
                                        class="btn btn-primary">Define</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <!-- Add pagination links -->
                <div class="d-flex justify-content-center">
                    {{ $installments->links() }}
                </div>
            </div>
        </div>
    </div>
@endsection
