@extends('layouts.admin_layout')


@section('content')
    <form action="{{ route('installmentdetail.store') }}" target="_blank" method="post">
        @csrf

        <input type="hidden" name="installment_id" value="{{ $installments->id }}">
        <div class="container-fluid">

            <div class="row fw-bolder bg-white p-3 text-center">
                <div class="col-md-1">
                    ID
                </div>
                <div class="col-md-3">
                    Amount
                </div>
                <div class="col-md-3">
                    Installment Name
                </div>
                <div class="col-md-3">
                    Due Date
                </div>
            </div>

            @php
                $details = $installments->details->toArray();
            @endphp

            @for ($i = 0; $i < $installments->total_installments; $i++)
                <div class="row form-group bg-white m-3 p-2">
                    <div class="col-md-1">
                        {{ isset($details[$i]['id']) ? $details[$i]['id'] : '' }}
                    </div>
                    <div class="col-md-3">
                        <input type="number" name="amount[]"
                            value="{{ isset($details[$i]['amount']) ? $details[$i]['amount'] : '' }}" class="form-control"
                            required>
                    </div>
                    <div class="col-md-3">
                        <input type="text" name="name[]"
                            value="{{ isset($details[$i]['name']) ? $details[$i]['name'] : '' }}" class="form-control"
                            required>
                    </div>
                    <div class="col-md-3">
                        <input type="date" name="date[]"
                            value="{{ isset($details[$i]['date']) ? date('Y-m-d', strtotime($details[$i]['date'])) : '' }}"
                            class="form-control" required>
                    </div>
                </div>
            @endfor




            <div class="bg-white p-3">

                <button type="submit" class="btn btn-primary offset-4 p-3">Create Installments</button>
            </div>

    </form>
@endsection
