@extends('layouts.admin_layout')

@section('content')
    <div class="container-fluid">
        <table class="table-responsive table table-striped">
            <thead>
                <tr class="fw-bolder bg-white p-3 text-center">
                    <td class="col-md-1">ID</td>
                    <td class="col-md-1 w-75" style="min-width: 150px;">Amount</td>
                    <td class="col-md-1">Installment Name</td>
                    <td class="col-md-2 text-center">Due Date</td>
                    <td class="col-md-2 text-center">Receive Date</td>
                    <td class="col-md-1 text-center">Status</td>
                    <td class="col-md-2 text-center d-none">Receive Amount</td>
                    <td class="col-md-2 text-center">Slip #</td>
                    <td class="col-md-1 text-center">Action</td>
                </tr>
            </thead>
            <tbody>
                @foreach ($installment_details as $details)
                    @php
                        $dueDate = new DateTime($details->date);
                        $currentDate = new DateTime();
                        $difference = $dueDate->diff($currentDate);

                        $fine = 0;
                        if ($dueDate < $currentDate) {
                            $fine = ($details->amount / 100) * 2;
                            $daysInMonth = cal_days_in_month(
                                CAL_GREGORIAN,
                                $dueDate->format('m'),
                                $dueDate->format('Y'),
                            );
                            $fine = $fine / $daysInMonth;
                        }

                        // Determine if the installment has been received
                        $user_installment = $user_installments->get($details->id);
                        $isReceived = isset($user_installment);
                        $receivedAmount = $isReceived ? $user_installment->received_amount : 0;
                        $slipNo = $isReceived ? $user_installment->slip_no : '';
                        $status = $isReceived ? 'Received' : 'Pending';
                    @endphp

                    <form action="{{ route('installments.user.add') }}" method="post">
                        @csrf
                        <tr>
                            <td class="col-md-1 text-center">{{ $details->id }}</td>
                            <td class="col-md-1 text-center" style="min-width: 130px;">
                                <div>{{ $details->amount }}</div>
                                @if (!$isReceived)
                                    <input class="form-control w-75" style="min-width: 180px;" type="number"
                                        name="received_amount" value="{{ round($details->amount, 3) }}">
                                @else
                                    <div class="badge badge-success m-1">Received - {{ $receivedAmount }}</div>
                                @endif
                            </td>
                            <td class="col-md-1 text-center"><label>{{ $details->name }}</label></td>
                            <td class="col-md-2 text-center">
                                <label>{{ date('Y-m-d', strtotime($details->date)) }}</label>
                                @if (!$isReceived && $fine > 0)
                                    <br>
                                    <strong>Penalty</strong>
                                    <select name="fine_type" id="fine_type" class="form_control" onchange="charge_fine();">
                                        <option value="two_per_anum">- Select Fine -</option>
                                        <option value="two_per_anum">2% per annum - Days {{ $difference->days }}</option>
                                        <option value="two_per_month">2% per month - Days {{ $difference->days }}</option>
                                        <option value="one_per_month">1% per month - Days {{ $difference->days }}</option>
                                        <option value="two_per_day">2% per day</option>
                                    </select>
                                @endif
                            </td>
                            <td class="col-md-2 text-center">
                                @if ($isReceived)
                                    {{ $user_installment->receiving_date }}
                                @else
                                    <input type="date" name="receiving_date" class="date form-control">
                                @endif
                            </td>
                            <td class="col-md-1 text-center">
                                <span
                                    class="badge badge-{{ $isReceived ? 'success' : 'danger' }}">{{ $status }}</span>
                            </td>
                            <td class="col-md-2 text-center" style="min-width: 100px;">
                                @if ($isReceived)
                                    {{ $slipNo }}
                                @else
                                    <input type="text" name="slip_no" class="form-control" style="min-width: 70px;">
                                @endif
                            </td>
                            <input type="hidden" name="installment_detail" value="{{ $details->id }}">
                            <input type="hidden" name="allotment" value="{{ $allotment->id }}">
                            <td class="col-md-2 text-center">
                                @if (!$isReceived)
                                    <button class="btn btn-success btn-sm" type="submit">Receive</button>
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                    </form>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection
