@extends('layouts.admin_layout')
@section('content')

    <div class="card">
        <div class="card-header">
            Assing Items </div>
        <style>
            .form-control1 {
                width: 100% !important;

                border-color: #bdbdbd !important;
                border-radius: 0.3rem !important;
                box-shadow: none !important;
                transition: border-color 0.2s ease-in-out !important;
                height: 39px;
                padding: 5px;
            }
        </style>

        <div class="card-body">
            @if (session('success'))
                <div class="alert alert-success" role="alert">
                    {{ session('success') }}
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger" role="alert">
                    {{ session('error') }}
                </div>
            @endif

            <form action="{{ route('admin.inventory.assign.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">


                    <div class="form-group {{ $errors->has('status_id') ? 'has-error' : '' }} col-md-6">
                        <label for="status">{{ trans('cruds.inventory.fields.item') }}*</label>
                        <select name="inventory_id" class="form-select select2" required>
                            @foreach ($inventory as $item)
                                <option value="{{ $item->id }}">{{ $item->item->item }}</option>
                            @endforeach
                        </select>
                        @if ($errors->has('status_id'))
                            <em class="invalid-feedback">
                                {{ $errors->first('status_id') }}
                            </em>
                        @endif
                    </div>

                    <div class="status-user form-group {{ $errors->has('status_id') ? 'has-error' : '' }} col-md-6">
                        <label for="status">{{ trans('cruds.inventory.fields.assign_to') }}*</label>
                        <input type="hidden" name="created_by" value="{{ $user_id }}">
                        <select name="department_id" id="department_id" class="form-select select2">
                            @foreach ($departments as $department)
                                <option value="{{ $department->id }}">{{ $department->department }}</option>
                            @endforeach
                        </select>
                        @if ($errors->has('department_id'))
                            <em class="invalid-feedback">
                                {{ $errors->first('department_id') }}
                            </em>
                        @endif
                    </div>


                    <div class="form-group  col-md-6">
                        <label for="quantity">Quantity</label>
                        <input type="number" id="quantity" name="quantity" class="form-control1">
                    </div>

                    <div>
                        <input class="btn btn-danger" type="submit" value="{{ trans('global.save') }}">
                    </div>
                </div>
            </form>


        </div>
    </div>
@endsection

@section('scripts')


@stop
