@extends('layouts.admin_layout')

@section('css')
    <style>
        .pagination {
            margin: 20px 0;
        }

        .pagination .page-link {
            font-size: 0.875rem;
            padding: 5px 10px;
        }

        .pagination .page-item.active .page-link {
            background-color: #007bff;
            border-color: #007bff;
        }

        .pagination .page-link:hover {
            background-color: #e9ecef;
        }
    </style>
@endsection

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="card-title m-0">Inventory Assignment List</h5>

            <a class="btn btn-success m-3" href="{{ route('admin.inventory.assign.item') }}">
                Assign Item
            </a>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover datatable datatable-Inventory" id="example">
                    <thead>
                        <tr>
                            <th width="10"></th>
                            <th>ID</th>
                            <th>Department Name</th>
                            <th>Product</th>
                            <th>Quantity Assigned</th>
                            <th>{{ trans('global.action') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($assignments as $data)
                            <tr data-entry-id="{{ $data->id }}">
                                <td></td>
                                <td>{{ $data->id ?? '' }}</td>
                                <td>{{ optional($data->department)->department ?? optional($data->user)->name }}</td>
                                <td>{{ $data->item->item ?? '' }}</td>
                                <td>{{ $data->quantity ?? '' }}</td>
                                <td>
                                    <a class="btn btn-xs btn-info" href="{{ route('admin.inventory.edit', $data->id) }}">
                                        {{ trans('global.edit') }}
                                    </a>

                                    <form action="{{ route('admin.inventory.destroy', $data->id) }}" method="POST"
                                        onsubmit="return confirm('{{ trans('global.areYouSure') }}');"
                                        style="display: inline-block;">
                                        @method('DELETE')
                                        @csrf
                                        <input type="submit" class="btn btn-xs btn-danger"
                                            value="{{ trans('global.delete') }}">
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6">{{ trans('global.no_data') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
@endsection
