@extends('layouts.admin_layout')
@section('content')

    <div class="card">
        <div class="card-header">
            {{ trans('global.create') }} {{ trans('cruds.inventory.title_singular') }}
        </div>
        <style>
            .form-control {
                width: 100% !important;

                border-color: #bdbdbd !important;
                border-radius: 0.3rem !important;
                box-shadow: none !important;
                transition: border-color 0.2s ease-in-out !important;
                height: 39px;
                padding: 5px;
            }
        </style>

        <div class="card-body">
            <form action="{{ route('admin.inventory.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="form-group {{ $errors->has('title') ? 'has-error' : '' }} col-md-6">
                        <label for="batch">{{ trans('cruds.inventory.fields.batch') }}*</label>
                        <input type="text" value="{{ $date_random_batch }}" id="batch" name="batch"
                            class="form-control" required>
                        @if ($errors->has('batch'))
                            <em class="invalid-feedback">
                                {{ $errors->first('batch') }}
                            </em>
                        @endif
                        <p class="helper-block">
                            {{-- {{ trans('cruds.ticket.fields.batch') }} --}}
                        </p>
                    </div>

                    <div class="form-group {{ $errors->has('status_id') ? 'has-error' : '' }} col-md-6">
                        <label for="status">{{ trans('cruds.inventory.fields.item') }}*</label>
                        <select name="item_id" class="form-select select2" required>
                            @foreach ($items as $id => $item)
                                <option value="{{ $id }}">{{ $item }}</option>
                            @endforeach
                        </select>
                        @if ($errors->has('status_id'))
                            <em class="invalid-feedback">
                                {{ $errors->first('status_id') }}
                            </em>
                        @endif
                    </div>

                    <div class="form-group {{ $errors->has('status_id') ? 'has-error' : '' }} col-md-6">
                        <label for="status">{{ trans('cruds.inventory.fields.status') }}*</label>
                        <select name="status" onchange="return assign_inventory_status(this);" id="status"
                            class="form-select select2" required>
                            <option value=""> {{ trans('cruds.inventory.fields.select_status') }}</option>
                            <option value="in_store"> {{ trans('cruds.inventory.fields.in_store') }}</option>
                            {{-- <option value="assigned_to">{{ trans('cruds.inventory.fields.assigned_to') }}</option> --}}
                            <option value="expired"> {{ trans('cruds.inventory.fields.expired') }}</option>
                        </select>
                        @if ($errors->has('status_id'))
                            <em class="invalid-feedback">
                                {{ $errors->first('status_id') }}
                            </em>
                        @endif
                    </div>

                    <div style="display:none;"
                        class="status-user form-group {{ $errors->has('status_id') ? 'has-error' : '' }} col-md-6">
                        <label for="status">{{ trans('cruds.inventory.fields.assign_to') }}*</label>
                        <input type="hidden" name="created_by" value="{{ $user_id }}">
                        <select name="user_id" id="status-user" class="form-select select2">
                            @foreach ($users as $id => $user)
                                <option value="{{ $id }}">{{ $user }}</option>
                            @endforeach
                        </select>
                        @if ($errors->has('status_id'))
                            <em class="invalid-feedback">
                                {{ $errors->first('status_id') }}
                            </em>
                        @endif
                    </div>

                    <div style="display:none;"
                        class="status-store form-group {{ $errors->has('status_id') ? 'has-error' : '' }} col-md-6">
                        <label for="status">{{ trans('cruds.inventory.fields.store') }}*</label>

                        <select name="store_id" id="status-store" class="form-control select2">
                            @foreach ($stores as $id => $store)
                                <option value="{{ $id }}">{{ $store }}</option>
                            @endforeach
                        </select>
                        @if ($errors->has('status_id'))
                            <em class="invalid-feedback">
                                {{ $errors->first('status_id') }}
                            </em>
                        @endif
                    </div>

                    <div class="form-group {{ $errors->has('author_name') ? 'has-error' : '' }} col-md-6">
                        <label for="count">{{ trans('cruds.inventory.fields.count') }}</label>
                        <input type="number" id="count" name="count" class="form-control">
                        @if ($errors->has('author_name'))
                            <em class="invalid-feedback">
                                {{ $errors->first('author_name') }}
                            </em>
                        @endif
                        <p class="helper-block">
                            {{ trans('cruds.ticket.fields.author_name_helper') }}
                        </p>
                    </div>
                    <div class="form-group  col-md-6">
                        <label for="price">Price</label>
                        <input type="number" id="price" name="price" class="form-control">
                    </div>

                    <div>
                        <input class="btn btn-danger" type="submit" value="{{ trans('global.save') }}">
                    </div>
                </div>
            </form>


        </div>
    </div>
    <script>
        function assign_inventory_status() {
            var status = $("#status option:selected").val();

            if (status == 'in_store') {
                $(".status-user").css({
                    "display": "none"
                });
                $("#status-user").attr('required', false);

                $(".status-store").css({
                    "display": "inline",
                    "color": "green"
                });
                $("#status-store").attr('required', true);

            } else
            if (status == 'assigned_to') {
                $(".status-user").css({
                    "display": "inline",
                    "color": "green"
                });
                $("#status-user").attr('required', true);

                $(".status-store").css({
                    "display": "none"
                });
                $("#status-store").attr('required', false);


            } else {
                $(".status-user").css({
                    "display": "none"
                });
                $(".status-store").css({
                    "display": "none"
                });

                $("#status-store").attr('required', false);
                $("#status-user").attr('required', false);

            }
        }
    </script>
@endsection

@section('scripts')
    <script>
        var uploadedAttachmentsMap = {}
        Dropzone.options.attachmentsDropzone = {
            {{--    url: '{{ route('tickets.storeMedia') }}', --}}
            maxFilesize: 2, // MB
            addRemoveLinks: true,
            headers: {
                'X-CSRF-TOKEN': "{{ csrf_token() }}"
            },
            params: {
                size: 2
            },
            success: function(file, response) {
                $('form').append('<input type="hidden" name="attachments[]" value="' + response.name + '">')
                uploadedAttachmentsMap[file.name] = response.name
            },
            removedfile: function(file) {
                file.previewElement.remove()
                var name = ''
                if (typeof file.file_name !== 'undefined') {
                    name = file.file_name
                } else {
                    name = uploadedAttachmentsMap[file.name]
                }
                $('form').find('input[name="attachments[]"][value="' + name + '"]').remove()
            },
            init: function() {
                @if (isset($ticket) && $ticket->attachments)
                    var files =
                        {!! json_encode($ticket->attachments) !!}
                    for (var i in files) {
                        var file = files[i]
                        this.options.addedfile.call(this, file)
                        file.previewElement.classList.add('dz-complete')
                        $('form').append('<input type="hidden" name="attachments[]" value="' + file.file_name +
                            '">')
                    }
                @endif
            },
            error: function(file, response) {
                if ($.type(response) === 'string') {
                    var message = response //dropzone sends it's own error messages in string
                } else {
                    var message = response.errors.file
                }
                file.previewElement.classList.add('dz-error')
                _ref = file.previewElement.querySelectorAll('[data-dz-errormessage]')
                _results = []
                for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                    node = _ref[_i]
                    _results.push(node.textContent = message)
                }

                return _results
            }
        }
    </script>


@stop
