@extends('layouts.admin_layout')

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="card-title m-0">{{ trans('cruds.inventory.title_singular') }} {{ trans('global.list') }}</h5>
            <div class="btn-group" role="group">
                <a class="btn btn-success" href="{{ route('admin.inventory.create') }}">
                    {{ trans('global.add') }} {{ trans('cruds.inventory.title_singular') }}
                </a>
                <a class="btn btn-success" href="{{ route('admin.inventory.assign.item') }}">
                    Assign Item
                </a>
                <a class="btn btn-success" href="{{ route('admin.inventory.assign.list') }}">
                    View Assign List
                </a>
            </div>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover datatable datatable-Inventory">
                    <thead>
                        <tr>
                            <th width="10"></th>
                            <th>{{ trans('cruds.inventory.fields.id') }}</th>
                            <th>{{ trans('cruds.inventory.fields.item') }}</th>
                            <th>{{ trans('cruds.inventory.fields.status') }}</th>
                            <th>{{ trans('cruds.inventory.fields.assigned_to') }}</th>
                            <th>{{ trans('cruds.inventory.fields.store') }}</th>
                            <th>{{ trans('cruds.inventory.fields.count') }}</th>
                            <th>{{ trans('Available Stock') }}</th>
                            <th>{{ trans('cruds.inventory.fields.batch') }}</th>
                            <th>{{ trans('global.action') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($inventory as $batch)
                            <tr data-entry-id="{{ $batch->id }}">
                                <td></td>
                                <td>{{ $batch->id ?? '' }}</td>
                                <td>{{ $batch->item->item ?? '' }}</td>
                                <td>{{ trans('cruds.inventory.fields.' . $batch->status) ?? '' }}</td>
                                <td>{{ $batch->user->name ?? '' }}</td>
                                <td>{{ $batch->store->store ?? '' }}</td>
                                <td>{{ $batch->count ?? '' }}</td>
                                <td>{{ $batch->available_stock ?? '' }}</td>
                                <td>{{ $batch->batch ?? '' }}</td>
                                <td>
                                    <a class="btn btn-info btn-sm" href="{{ route('admin.inventory.edit', $batch->id) }}">
                                        {{ trans('global.edit') }}
                                    </a>

                                    <form action="{{ route('admin.inventory.destroy', $batch->id) }}" method="POST"
                                        onsubmit="return confirm('{{ trans('global.areYouSure') }}');"
                                        style="display: inline;">
                                        @csrf
                                        @method('DELETE')
                                        <input type="submit" class="btn btn-danger btn-sm"
                                            value="{{ trans('global.delete') }}">
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <!-- Pagination links -->
                <div class="d-flex justify-content-center mt-3">
                    {{ $inventory->links('pagination::bootstrap-4') }}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    @parent
    <script>
        $(function() {
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons);

            @can('commentdelete')
                let deleteButtonTrans = '{{ trans('global.datatables.delete') }}';
                let deleteButton = {
                    text: deleteButtonTrans,
                    url: "{{ route('admin.inventory.massDestroy') }}",
                    className: 'btn-danger',
                    action: function(e, dt, node, config) {
                        var ids = $.map(dt.rows({
                            selected: true
                        }).nodes(), function(entry) {
                            return $(entry).data('entry-id');
                        });

                        if (ids.length === 0) {
                            alert('{{ trans('global.datatables.zero_selected') }}');
                            return;
                        }

                        if (confirm('{{ trans('global.areYouSure') }}')) {
                            $.ajax({
                                    headers: {
                                        'x-csrf-token': _token
                                    },
                                    method: 'POST',
                                    url: config.url,
                                    data: {
                                        ids: ids,
                                        _method: 'DELETE'
                                    }
                                })
                                .done(function() {
                                    location.reload();
                                });
                        }
                    }
                };
                dtButtons.push(deleteButton);
            @endcan

            $.extend(true, $.fn.dataTable.defaults, {
                order: [
                    [1, 'desc']
                ],
                pageLength: 100,
            });

            $('.datatable-Inventory:not(.ajaxTable)').DataTable({
                buttons: dtButtons
            });

            $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
                $($.fn.dataTable.tables(true)).DataTable().columns.adjust();
            });
        });
    </script>
@endsection
