@extends('layouts.admin_layout')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.item.title') }}
    </div>

    <div class="card-body">
        <form action="{{ route("admin.items.update", [$item->id]) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')


            <div class="form-group {{ $errors->has('item_name') ? 'has-error' : '' }}">
                <label for="author_name">{{ trans('cruds.item.title_singular') }}*</label>
                <input type="text" id="item" value="{{$item->item}}" name="item" class="form-control"  required>
                @if($errors->has('item_name'))
                    <em class="invalid-feedback">
                        {{ $errors->first('item_name') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{--                    {{ trans('cruds.comment.fields.author_name_helper') }}--}}
                </p>
            </div>

            <div class="form-group {{ $errors->has('comment_text') ? 'has-error' : '' }}">
                <label for="comment_text">{{ trans('global.details') }}*</label>
                <textarea id="comment_text" name="details" class="form-control " required>{{$item->details}}</textarea>
                @if($errors->has('comment_text'))
                    <em class="invalid-feedback">
                        {{ $errors->first('comment_text') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('cruds.comment.fields.comment_text_helper') }}
                </p>
            </div>


            <div>
                <input class="btn btn-danger" type="submit" value="{{ trans('global.save') }}">
            </div>
        </form>


    </div>
</div>
@endsection
