@extends('layouts.admin_layout')

@section('content')
<style>
#bmr {
font-family: "Calibri";
font-size: 16px;
}
#is_pregnant{
visibility: visible;
opacity: 1;
}

</style>

<div class="container" style="margin-top: 30px;">

<div class="row">
<div class="col-sm-8">
<div class="card  col-11"  style="border: 1.4px solid #51377f;">

<div class="card-body p-0 mt-4">
<div class="row m-0" >
<div class="col-md-12">
<div class="col-sm-12 col-md-8 offset-md-1 border-1 rounded-pill     " >
<div class="form-group input-group-append">

<input type="text" class="form-control p-2" id="full_name" value="{{@$user->name}}"
name="full_name" placeholder="Full name">


<button type="button" id="info_button" class="btn btn-sm btn-outline-primary   ml-5 font-weight-bold mb-3  "
onclick="confirm_info()"
>
@if($user->name)
Update
@else
Confirm
@endif
</button>
</div>
</div>

<div class="col-sm-10 col-md-12 ms-4 mb-3 mt-1" id="gender" >

<div class="custom-control custom-radio custom-control-inline ml-4">
<input type="radio" id="male" value="male" onchange="gender_questions(this.id);" {{$user->gender == 'male' ? "checked" : ""}} name="gender" class="custom-control-input">
<label class="custom-control-label font-weight-bold"  for="male"> <i class="mdi mdi-gender-male"></i>Male </label>
</div>

<div class="custom-control custom-radio custom-control-inline">
<input type="radio" id="female" value="female" onchange="gender_questions(this.id);" {{$user->gender == 'female' ? "checked" : ""}} name="gender" class="custom-control-input">
<label class="custom-control-label font-weight-bold" for="female"> <i class="mdi mdi-gender-female"></i>Female </label>


</div>

<div class="alert alert-success ml-4     mb-2 alert-dismissible" id="info_helper" style="display: none;" role="alert">
<strong>updated!</strong>
</div>
</div>

</div>

</div>
</div>
</div>

<div class="row mt-3 ms-1" id="question_box">
<style>
.importantRule { display: none; }

</style>
<div id="is_female" class="col-md-4 card shadow-sm {{$user->gender == 'female' ? 'd-inline' : 'd-none'}}"
style="border: 1.5px solid #aa3fb8; ">
<div class="card-body" id="bmr">

<div class="form-group"  >

@php $q =  config('questions.2.q'); @endphp

<label class="font-weight-bolder">  {{$q}}  </label>

<div id="pregnancy_options">
@foreach( config('questions.2.options') as $option )

<div class="custom-control custom-switch">
<input type="checkbox" onchange="change_pregnancy(this.id);" class="custom-control-input" name="pregnant[]"
       value="{{ucfirst($option)}}" id="{{ucfirst($option)}}_{{ucfirst($option)}}">

<label class="custom-control-label" for="{{ucfirst($option)}}_{{ucfirst($option)}}">{{ucfirst($option)}}</label>
</div>
@endforeach

</div>

<div id="is_pregnant" class="mt-3" style="display: none;">
<label class="font-weight-bolder"> How many months?  </label>
@foreach( config('questions.2.pregnant.options') as $option )

<div class="custom-control custom-radio">
<input type="radio" onchange="change_pregnancy();" class="custom-control-input" name="pregnant[]" value="{{ucfirst($option)}}" id="{{ucfirst($option)}}_{{ucfirst($option)}}">
<label class="custom-control-label" for="{{ucfirst($option)}}_{{ucfirst($option)}}">{{ucfirst($option)}}</label>
</div>
@endforeach

</div>


<div class="form-group m-0">
<label class="font-weight-bold">
Are you breastfeeding?
</label>
@foreach( config('questions.3.options') as $option )

<div class="custom-control custom-radio">
<input type="radio" onchange="change_pregnancy();" class="custom-control-input" name="pregnant[]" value="{{ucfirst($option)}}" id="{{ucfirst($option)}}_{{ucfirst($option)}}">
<label class="custom-control-label" for="{{ucfirst($option)}}_{{ucfirst($option)}}">{{ucfirst($option)}}</label>
</div>
@endforeach

</div>
</div>
</div>

</div>
</span>

<div class="col-md-6 card shadow-sm ml-2 {{isset($user->gender) ? 'd-inline' : 'd-none'}}"  style="border: 1.5px solid #51377f; ">
<div class="d-flex justify-content-around">
<button type="button" id="previous_step" class="btn-outline-success
btn btn-sm mt-3 mb-4 float-right"  disabled
    onclick="decide_question_order(this.id);">
    < Previous
</button>
<button type="button" id="next_step" class="btn-outline-success btn btn-sm mt-3 mb-4 float-right"
    onclick="decide_question_order(this.id);">
 Next >
</button>
</div>
<div class="card-body" id="question_order" data-question-id="6" >

<div class="form-group"   >

<label class="font-weight-bold">  {{config('questions.4.q')}}  </label>

<div>
<input type="date" class="form-control" id="dob"
value="{{date('Y-m-d',strtotime($user->dob))}}" >
</div>

<div class="mt-3">
<label class="font-weight-bold">  {{config('questions.5.q')}}  </label>

<nav>
<div class="nav nav-tabs" id="nav-tab" role="tablist">
<button class="nav-link active" id="nav-home-tab" data-toggle="tab"
        data-target="#nav-home" type="button" role="tab" aria-controls="nav-home" aria-selected="true">
    Imperal
</button>
<button class="nav-link" id="nav-profile-tab" data-toggle="tab" data-target="#nav-profile" type="button" role="tab"
        aria-controls="nav-profile" aria-selected="false">
    Metric
</button>
</div>
</nav>
<div class="tab-content" id="nav-tabContent">
<div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">
@php
    $decimal = range(1, 12, 1);
    $options = (range(1.0,8.0));
    $cms = (range(1,234));
@endphp
<select class="form-control" id="height_feet" onchange="calculate_bmr(this.id);">
    @foreach($options as $feet)
        @foreach($decimal as $inch)
            @php $height = $feet.".".$inch;
                 $cm = round($height * 30.48,0);

            @endphp
            <option value="{{$feet}}.{{$inch}}" {{$user->height == $cm ? "selected" : ""}} >
                {{$feet}}‘ {{$inch}}“
            </option>
        @endforeach
    @endforeach
</select>
</div>
<div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab">
<select class="form-control" id="height_cm" onchange="calculate_bmr(this.id);">
    @foreach($cms as $cm)
        <option id="cm">
            {{$cm}}
        </option>
    @endforeach
</select>
</div>
</div>

</div>

<div class="mt-3" >
<label class="font-weight-bold">  {{config('questions.6.q')}}  </label>

<nav>
<div class="nav nav-tabs" id="nav-tab" role="tablist">
<button class="nav-link active" id="nav-home-tab" data-toggle="tab"
        data-target="#nav-height-imperial" type="button" role="tab" aria-controls="nav-home" aria-selected="true">
    Imperal
</button>
<button class="nav-link" id="nav-profile-tab" data-toggle="tab" data-target="#nav-height-metric" type="button" role="tab"
        aria-controls="nav-profile" aria-selected="false">
    Metric
</button>
</div>
</nav>
<div class="tab-content" id="nav-tabContent">
<div class="tab-pane fade show active active" id="nav-height-imperial" role="tabpanel" aria-labelledby="nav-home-tab">
@php
    $gms = config('bmr.weight');

 $imperial = (range($gms['imperial'][0],$gms['imperial'][1]));
 $metric = (range($gms['metric'][0],$gms['metric'][1]));

@endphp
<select class="form-control" id="weight_lb" onchange="calculate_bmr(this.id);">

    @foreach($imperial as $lbs )
        <option value="{{$lbs}}">
            ,{{$lbs}} lb
    @endforeach

</select>
</div>

<div class="tab-pane fade" id="nav-height-metric" role="tabpanel" aria-labelledby="nav-profile-tab">
<select class="form-control" id="weight_kg" onchange="calculate_bmr(this.id);">
    @foreach($metric as $kg)
        <option  >
            {{$kg}}
        </option>
    @endforeach
</select>
</div>
</div>


</div>


</div>
</div>

</div>

</div>

</div>

<div class="col-md-4 card shadow-sm  {{isset($user->gender) ? 'd-inline' : 'd-none'}}">
<div class="w-100 text-center font-weight-bold display-4 mt-3 ">
My BMR
</div>

<h2 class="display-3 text-center mt-1" id="my_bmr"  style="background-color: rgba(28,28,21,0.62); box-shadow: 6px 3px 3px #33d639; color: whitesmoke; border: 2.3px solid #25d3a4;">

{{$user->bmr}}
</h2>

<div class="card-body">

<table class="table-hover table table-stripedw-100 text-center p-3 w-100 m-0" id="my_info">
<thead>
<tr>
<th  >
Age - y
</th>
<th  >
Weight - kg
</th> <th  >
Height - cm
</th>
</tr>
</thead>

@php
$bday = new Datetime($user->dob);
$today = new Datetime(date('m.d.y'));

$age = $today->diff($bday);
@endphp

<tbody>
<tr>
<td>
{{$age->y}}
</td>
<td>
{{$user->weight}}
</td>
<td>
{{$user->height}}
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>

<script>
// $('#height_lb').on('change', calculate_bmr);

var weight = null;
var height = null;



function confirm_info(){
var name = $('#full_name').val();
var gender = $('#gender input[type="radio"]:checked').val();

$.ajax({
/* the route pointing to the post function */
url: '{{route('add_info')}}',
type: 'POST',
/* send the csrf-token and the input to the controller */
data: {_token: '{{csrf_token()}}', name:name,gender:gender},
dataType: 'JSON',
/* remind that 'data' is the response of the AjaxController */
success: function (data) {
$("#info_button").text("Update");
$("#info_helper").css('display','inline');

setTimeout(function () {
$("#info_helper").fadeOut(2000);
},2000)

}
});

}
function gender_questions(thisid){

if(thisid =='female'){
$("#is_female").removeClass('importantRule');
$("#is_female").addClass('d-inline');


}
else{

$("#is_female").removeClass('d-inline');
$("#is_female").addClass('importantRule');

}


}
function change_pregnancy(thisid) {


if($('#No_No').is(":checked")){

$('#Pregnant_Pregnant').prop("checked", false);

$('#Pregnant_Pregnant').prop("disabled", true);

$("#is_pregnant").css('display','none');
}
else{
$('#Breastfeeding_Breastfeeding').prop("disabled", false);
$('#Pregnant_Pregnant').prop("disabled", false);
}

if(thisid == "Pregnant_Pregnant")
{
if($('#Pregnant_Pregnant').is(":checked"))
{
$("#is_pregnant").css('display','inline');
}
else {
$("#is_pregnant").css('display','none');
}
}

}
function get_bmr() {

if(!$('#dob').val())
{
alert('Please select Date Of birth.'); return false;
}

if(!height)
{
alert('Please select height.');
return false;
}

if(!weight)
{
alert('Please select weight.'); return false;
}

var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');

$.ajax({
/* the route pointing to the post function */
url: '{{route('get_bmr')}}',
type: 'POST',
/* send the csrf-token and the input to the controller */
data: {_token: '{{csrf_token()}}', height:height,weight:weight, dob: $('#dob').val()},
dataType: 'JSON',
async:true,
/* remind that 'data' is the response of the AjaxController */
success: function (data) {
$("#my_bmr").text(data.bmr);

$("#my_info").append("<tr><td>"+data.age +"</td> <td>"+data.weight +"</td><td>"+data.height+"</td> </tr>");

}
});

return true;
}
function calculate_bmr(thisid) {
var pound = 0.45;
var kg = 1;

var feet = 1;
var cm = 30.48;


if(thisid == 'weight_lb'){

weight  = pound * $("#"+thisid + " :selected").val();
}
else

if(thisid == 'weight_kg'){
weight  =  $("#"+thisid + " :selected").val();
}

if(thisid == 'height_feet'){

height  = cm * $("#"+thisid + " :selected").val();
}
else
if(thisid == 'height_cm'){
height  = $("#"+thisid + " :selected").val();
}
}

var options = [];
var answer = [];

var question_id = $("#question_order").data('question-id');
var bmr_column = $("#question_order").html();
var question_type = '';

function decide_question_order(thisid){

height = '{{$user->height}}';
weight = '{{$user->weight}}';

var  step = thisid;

if(thisid == 'previous_step'){
if((question_id - 1) == 6 ){
$("#question_order").html(bmr_column);
$("#previous_step").prop('disabled',true);
question_id = question_id - 1;
return false;
}
}

if(question_id == 6){
if(!get_bmr()){
return;
}
}

var checked = [];

if(question_type == 'multiple'){
    $('input.options_checked:checkbox:checked').each(function () {
        checked.push($(this).val());
});
}
else{

    checked.push($('input[name="options"]:checked').val());

}



var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');

$.ajax({
/* the route pointing to the post function */
url: '{{route('decide_question_order')}}',
type: 'POST',
/* send the csrf-token and the input to the controller */
data: {_token: '{{csrf_token()}}', options:options, question_id:question_id, step:step, checked:checked },
dataType: 'JSON',
/* remind that 'data' is the response of the AjaxController */
success: function (data) {

if(data.last){
        $("#next_step").prop('disabled',true);
        return false;
}else{
    $("#next_step").prop('disabled',false);

}

var form_group = '<div class="form-group">';
    form_group += '<label class="fw-bold">'+ data.question +'</label>';
     form_group += '</div><div id="options"> </div>';

    $("#question_order").html(form_group);

    var option = '';

        $.each(data.options, function (index,item) {
        if(data.type =='multiple'){
            option = '<div class="form-check form-check-inline">' +
                '<input class="form-check-input options_checked" type="checkbox" id="'+item.id+'" value="'+item.id+'"' +
                '> <label class="form-check-label" for="inlineCheckbox1">'+item.option+'</label> </div>';
            question_type = 'multiple';
        }else{
            option = '<div class="form-check form-check-inline">' +
                '<input class="form-check-input options_checked" name="options" type="radio" id="'+item.id+'" value="'+item.id+'"' +
                '> <label class="form-check-label" for="inlineCheckbox1">'+item.option+'</label> </div>';
            question_type = 'single';
        }



            $("#options").append(option);
    });


        $.each(data.answers, function (index,item) {
            $("#"+item.option_id).prop('checked',true);
        });






    if(thisid == 'next_step'){
        question_id = question_id + 1;
    }else{
            question_id = question_id - 1;
    }

if(question_id < 7){
    $("#previous_step").prop('disabled',true)
}else{
    $("#previous_step").prop('disabled',false)

}

console.log(data);

form_group = '';

data = '';
}
});

}
</script>




@endsection
