<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payslip</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>

<body class="bg-gray-100 p-10">
    <div class="max-w-4xl mx-auto bg-white p-6 rounded-lg shadow-lg">
        <h1 class="text-xl font-bold mb-4">Payslip for {{ $employee->name }}</h1>
        <p class="mb-2"><strong>Employee ID:</strong> {{ $employee->id }}</p>
        <p class="mb-2"><strong>Position:</strong> {{ $employee->position }}</p>
        <p class="mb-2"><strong>Month:</strong> {{ $salary->salary_month ?? 'N/A' }}</p>

        <table class="w-full border-collapse border border-gray-300 mt-6">
            <thead>
                <tr class="bg-gray-200">
                    <th class="border border-gray-300 p-2 text-left">Description</th>
                    <th class="border border-gray-300 p-2 text-right">Amount</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="border border-gray-300 p-2">Basic Salary</td>
                    <td class="border border-gray-300 p-2 text-right">{{ $salary->basic_salary ?? '0.00' }}</td>
                </tr>
                @foreach ($allowances as $allowance)
                    <tr>
                        <td class="border border-gray-300 p-2">Allowance ({{ $allowance->allowance_id }})</td>
                        <td class="border border-gray-300 p-2 text-right">{{ $allowance->amount }}</td>
                    </tr>
                @endforeach
                <tr>
                    <td class="border border-gray-300 p-2">Deductions</td>
                    <td class="border border-gray-300 p-2 text-right">{{ $salary->deductions ?? '0.00' }}</td>
                </tr>
                <tr class="font-bold">
                    <td class="border border-gray-300 p-2">Net Salary</td>
                    <td class="border border-gray-300 p-2 text-right">{{ $salary->net_salary ?? '0.00' }}</td>
                </tr>
            </tbody>
        </table>
    </div>
</body>

</html>
