@extends('layouts.admin_layout')


@section('content')

<script  src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBUXaN7NnVnN-NdGZPran1meQGhw0duWX4&libraries=places"></script>

@if(\Session::has('missing'))
<span class="row mx-auto font-weight-bolder text-center mt-2 alert alert-danger">
{{\session('missing')}}
</span>

@endif
<div class="container-fluid">
<form action="{{route('schemes.update',[$scheme->id])}}" method="post">
@csrf
    @method('patch')
<div class="row d-flex justify-content-center">
<div class="col-md-6 card-body bg-opacity-50 bg-white shadow-sm mb-4">
<div class="form-group">
<label>Type</label>
<select id="scheme_type" onchange="lock_form();" name="scheme_type" required class="form-control"   >
    <option value="" > - Select Scheme Type- </option>
    <option value="housing" {{$scheme->scheme_type == 'housing' ? "selected" : ""}} >Housing</option>
    <option value="building" {{$scheme->scheme_type == 'building' ? "selected" : ""}}>Building</option>
</select>
</div>

<div class="item form-group">
<label class="control-label" for="first-name">
    Name of Project / Scheme<span class="required">*</span>
</label>
<div class=" ">
    <input type="text" id="name" name="name"
           required class="form-control" value="{{$scheme->name}}" />
</div>

</div>


<div class="item form-group">
<label class="control-label " for="first-name"> ADP No <span class="required">*</span>
</label>
<div class=" ">
    <input type="text" id="adp_no" name="adp_no" required class="form-control " value="{{$scheme->adp_no}}" />
</div>
</div>

<div class="item form-group " >
<label class="control-label " for="first-name"> Price
    <span class="required">*</span>
</label>

<div class=" ">
    <input type="number" id="price" name="price" required class="form-control" value="{{$scheme->price}}" />
</div>
</div>
    <div class="item form-group " >
        <label class="control-label " for="first-name" id="plots_title"> {{$scheme->scheme_type == 'building' ? 'Total Flats ' : "Total Plots "}}
            <span class="required">*</span>
        </label>

        <div class=" ">
            <input type="number" id="total_plots" value="{{$scheme->total_plots}}" name="total_plots" required class="form-control" value="200" />
        </div>
    </div>
<div class="item form-group" >
<label class="control-label " for="first-name"> Project / Scheme Status <span class="required">*</span>
</label>
<div class=" ">
    <select id="status" value="{{$scheme->status}}"  name="status" required class="form-control " >
        <option value="in_process" {{$scheme->scheme_type == 'building' ? "in_process" : ""}}  selected >In Process</option>
        <option value="completed" {{$scheme->scheme_type == 'building' ? "completed" : ""}} >Completed</option>
    </select>
</div>
</div>

<div class="form-group">
<label for="">City
    <label class="text-muted">
        * auto-completed
    </label></label>

<input type="text" name="location"   class="form-control" placeholder="Enter City" id="location" value="{{$scheme->location}}" >
</div>

<div class="form-group">
    <input type="hidden"  class="form-control" id="longitude" value="{{$scheme->longitude}}" name="longitude"  >
    <input type="hidden"   class="form-control" id="latitude" value="{{$scheme->latitude}}" name="latitude"  >
</div>
</div>
<div class="col-md-5">
<div id='map_canvas'></div>
<br>
<h4 >Chalet Location Marker (for navigation).</h4>
<div id="current" class="card-header">

</div>
</div>
</div>

    <div class="row d-none" >
<span class="card-header text-center bg-white shadow-sm">
    <h2>Total Plots</h2>
</span>
        <div class="card-body bg-white row">
            @foreach(\App\Models\PlotSizes::all() as $size)
                <div class="col-md-2">
                    <label class="m-2"> {{$size->name}} </label>
                    <input type="hidden" name="names[]" value="{{$size->id}}" >
                    <input type="number" name="sizes[]" value="{{$scheme->quota}}"  class="form-control">
                </div>
            @endforeach
        </div>
    </div>


    <div class="row font-weight-bolder card-header shadow-sm bg-white mb-5" >
        <label class="control-label col-md-3 text-center"
               id="size_title">
            {{$scheme->scheme_type == 'building' ? 'Flat/Apprtment Size ' : "Plot/Apprtment Size "}}
              </label>
        <label class="control-label col-md-3" style="text-align:center"> Category  <span class="required">*</span></label>

        {{--    <label class="control-label col-md-2" style="text-align:center"> Total Plot/Apprtment  <span class="required">*</span></label>--}}

        <label class="col-md-2" style="text-align:center"> Total Auction  <span class="required">*</span></label>
        <label class="col-md-3 text-center" style="text-align:center"> Action   </label>

    </div>
    <div id="plots" style="min-height: 300px; width: 100%;">

        @if(count($scheme->quota))
            @foreach($scheme->quota as $quota)
            <div class="row mb-3 mt-3 card-header shadow-sm bg-white row_{{$quota->id}}"  id="size_row">
                <div class="col-md-3 font-weight-bold mb-3 text-center">
                    <select class="form-control" id="employ_quotta" name="size_id[]">
                        @foreach(\App\Models\PlotSizes::all() as $size)
                            <option value="{{$size->id}}" {{$quota->size_id == $size->id ? "selected" : ""}}>
                                {{$size->name}}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-3">
                    <select class="form-control" name="category[]">
                        @foreach(\App\Models\PlotCategories::all() as $category)
                            <option value="{{$category->id}}" {{$quota->quota_category == $category->id ? "selected" : ""}}>
                                {{$category->name}}
                            </option>
                        @endforeach
                    </select>
                </div>

                @php
                    $rand = rand(3493,23423423);
                @endphp

           <div class="col-md-4">
                    <input type="text" id="percentage_{{$rand}}" name="total_auction[]"   class="form-control " value="{{$quota->quota_amount}}" />
                    <label id="derived_{{$rand}}" class="fw-bold badge-success m-2">
                    </label>
           </div>

                <script>
                    // function  calculate_percentage(id) {
                    //               var quota =        $("#employ_quotta :selected").val();
                    //               var total =        $("#size_"+quota).val();
                    //               var percentage =   $("#percentage_"+id).val();
                    //
                    //               if(parseInt(percentage) > parseInt($("#size_"+quota).val())){
                    //                   alert('Category plots cannot be greater than total pltos.');
                    //                   $("#percentage_"+id).val('')
                    //                   return false;
                    //               }
                    //
                    //               var percentage =   ( 100 / total) * percentage;
                    //               $("#derived_"+id).text(Math.round(percentage) + " %");
                    // }
                </script>
                <div class="col-md-2 mx-auto text-center" id="add_button">
                    <button type="button" onclick="add_plot_size();" class="btn btn-sm btn-outline-secondary">
                        Add New
                    </button>
                    <button type="button" onclick="row_delete('{{$quota->id}}');" class="btn btn-sm btn-outline-warning">
                        Delete
                    </button>
                </div>
            </div>
            @endforeach

        @else

            <div class="row mb-3 mt-3 card-header shadow-sm bg-white"  id="size_row">
            <div class="col-md-3 font-weight-bold mb-3 text-center">
                <select class="form-control" id="employ_quotta" name="size_id[]">
                    @foreach(\App\Models\PlotSizes::all() as $size)
                        <option value="{{$size->id}}">
                            {{$size->name}}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-3">
                <select class="form-control" name="category[]">
                    @foreach(\App\Models\PlotCategories::all() as $category)
                        <option value="{{$category->id}}">
                            {{$category->name}}
                        </option>
                    @endforeach
                </select>
            </div>

            @php
                $rand = rand(3493,23423423);
            @endphp

            <div class="col-md-4">
                <input type="text" id="percentage_{{$rand}}" name="total_auction[]"   class="form-control " value="" />
                <label id="derived_{{$rand}}" class="fw-bold badge-success m-2">
                </label>
            </div>

            <script>
                // function  calculate_percentage(id) {
                //               var quota =        $("#employ_quotta :selected").val();
                //               var total =        $("#size_"+quota).val();
                //               var percentage =   $("#percentage_"+id).val();
                //
                //               if(parseInt(percentage) > parseInt($("#size_"+quota).val())){
                //                   alert('Category plots cannot be greater than total pltos.');
                //                   $("#percentage_"+id).val('')
                //                   return false;
                //               }
                //
                //               var percentage =   ( 100 / total) * percentage;
                //               $("#derived_"+id).text(Math.round(percentage) + " %");
                // }
            </script>
            <div class="col-md-2 mx-auto text-center" id="add_button">
                <button type="button" onclick="add_plot_size();" class="btn  btn-outline-primary">
                    Add New
                </button>
            </div>
        </div>

        @endif
    </div>
    <div>
        <hr>
    </div>

<div class="row bg-white shadow-sm p-3">
<button class="btn btn-primary col-3 offset-4" type="submit">
Update Scheme
</button>
</div>
</form>
</div>


<style>
#map_canvas{
width: 400px;
height: 300px;
}

#current{
padding-top: 25px;
}
</style>

<script>

var map = new google.maps.Map(document.getElementById('map_canvas'), {
zoom: 1,
center: new google.maps.LatLng(29.3117, 47.4818),
mapTypeId: google.maps.MapTypeId.ROADMAP
});

var myMarker = new google.maps.Marker({
position: new google.maps.LatLng("{{$scheme->latitude}}", "{{$scheme->longitude}}"),
draggable: true
});
google.maps.event.addListener(myMarker, 'dragend', function(evt){
document.getElementById('current').innerHTML =
'<p>latitude: ' +
evt.latLng.lat().toFixed(6) + '<br>' + ' longitude: ' + evt.latLng.lng().toFixed(6) + '</p>';

$('#latitude').val(evt.latLng.lat().toFixed(6));

$('#longitude').val(evt.latLng.lng().toFixed(6));

});

google.maps.event.addListener(myMarker, 'dragstart', function(evt){
document.getElementById('current').innerHTML = '<p>Currently dragging marker...</p>';
});

map.setZoom(10);
map.panTo(myMarker.position);
// map.setCenter(myMarker.position);
myMarker.setMap(map);

$(document).ready(function () {

var autocomplete;
var to = 'location';

autocomplete = new google.maps.places.Autocomplete((document.getElementById(to)),{
types:['geocode'],

});

google.maps.event.addListener(autocomplete, 'place_changed', function () {
var near_place = autocomplete.getPlace();


});
});

</script>
<script>
    function row_delete(row){
        $(".row_"+row).remove();

    }
    function  add_plot_size(){


        $("#add_button").remove();

        var row =   $('#size_row').html();

        $('#plots').append("<div class='row card-header shadow-sm mb-3 bg-white'>"+ row + "</div>");

        $("div[id=size_row]").removeAttr('id');

        var div  = $("#plots div").last().parent();
        div.attr('id',"size_row");


        var btn = "\n" +
            "             <div class=\"col-md-1 justify-content-center mx-auto text-center\" id=\"add_button\">\n" +
            "                <button type=\"button\" onclick=\"add_plot_size();\" class=\"btn btn-sm btn-outline-primary\">\n" +
            "                            Add\n" +
            "                </button>\n" +
            "            </div>"

        $('#size_row').append(btn);

    }

    function lock_form() {

        if ($("#scheme_type :selected").text() == 'Building') {

            // $("#plots").css('display', 'none');
            $("#plots_title").text("Total Flats")
            $("#size_title").text("Flat/Apartment Size");
        }
        else {
            $("#plots").css('display', 'inline');
            $("#plots_title").text("Total Plots");
            $("#size_title").text("Plot/Apartment Size");

        }
    }

</script>
@endsection









