@extends('layouts.admin_layout')

@section('content')


<div class="container-fluid  w-100">
<form method="post" action="{{route('schemes.update',[1])}}">
@method('patch')
@csrf

@if(Session::has('updated'))
<div class="alert alert-success alert-dismissible col-3 offset-4 mt-3 fade show" role="alert">
<strong>Updated!</strong>
<button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
</button>
</div>
@endif

    @if(Session::has('created'))
        <div class="alert alert-success alert-dismissible col-3 offset-4 mt-3 fade show" role="alert">
            <strong>{{session('created')}}</strong>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    <h3 class="display-5 bg-white shadow-sm m-2">
        Export Report
    </h3>
<table class="table table-hover bg-white w-100" id="table_schemes">
<thead>
<tr >
    <th>  Schemes </th>

    <th>  Total Units </th>


    <th class="text-center"> Type </th>
    <th class="text-center"> Location </th>
    <th class="text-center"> Price </th>
    <th class="text-center"> Status </th>
    <td>
        Action
    </td>
</tr>
</thead>
    <tbody>

@foreach(\App\Models\Scheme::all() as $scheme)
<tr>
         <td class="mt-4">
                <label class="row text-center mx-auto">
                    {{$scheme->name}}
                </label>
            <button class="btn btn-outline-primary btn-sm mt-3" type="button" data-bs-toggle="collapse" data-bs-target="#collapse_{{$scheme->id}}" aria-expanded="false" aria-controls="collapseExample">
                Plot Quota
            </button>
             <div class="collapse w-100 mt-2" id="collapse_{{$scheme->id}}">
                 <div class="card card-body">
                     <table>
                         <thead>
                         <tr>
                             <th>Plot Size </th>
                             <th>Total </th>
                             <th>Category </th>
                             <th> %
                             </th>
                             <th>
                                 Sceheme Total -
                                 {{$scheme->total_plots}}

                             </th>
                         </tr>
                         </thead>
                         <tbody>

                         @foreach($scheme->quota as $quota)
                             <tr>
                                 <td>
                                     {{$quota->plot_size->name}}
                                 </td>
                                 <td>
                                     {{$quota->total_units}}
                                 </td>
                                 <td>
                                     {{$quota->category->name}}
                                 </td>
                                 <td>
                                        <span class="badge badge-success m-2">
                                        {{$quota->quota_amount}} - Plots
                                        </span>

                                     <span class="badge badge-secondary m-2">
                                        {{$quota->quota_percentage}} %
                                        </span>

                                 </td>

                             </tr>
                         @endforeach

                         </tbody>
                     </table>
                 </div>
             </div>
         </td>
    <td>
        {{$scheme->total_plots}}

        </td>
        <td class="text-center">
            {{ucfirst($scheme->scheme_type)}}
        </td>

        <td class="text-center">
            {{ucfirst($scheme->location)}}

            <span class="badge  m-2 mx-auto d-block badge-dark">
               long - {{$scheme->longitude}}
            </span>
            <span class="badge d-block  mx-auto badge-dark badge-default">
                lat - {{$scheme->latitude}}
            </span>
        </td>

        <td class="text-center fw-bold">
           PKR - {{ucfirst($scheme->price)}}
        </td>
        <td class="text-center fw-bold">
             {{ucfirst($scheme->status)}}
        </td>
        <td class="text-center fw-bold">
            <a class="btn btn-primary" href="{{route('schemes.edit',[$scheme->id])}}">
                        Edit
            </a>
        </td>
</tr>

@endforeach
</tbody>
</table>
</form>
</div>

<script>
function add_option(id){
var start = ' <div class="col-auto input-group-append mt-2">';
var option = '<input type="text" class="form-control w-100" required style="width: auto !important;" name="option_'+id+'[]">';
var button = '<button class="btn btn-sm btn-outline-warning btn-icon-append" onclick="delete_option(this.id)"> ' +
'<span class="mdi mdi-delete-outline"></span> </button>';
var end = '</div>';
var stringed = start+option+button+end;
alert(stringed)
$("#unique_"+id).append(stringed);

}

</script>

<script>
    $(document).ready(function() {
        $('#table_schemes').DataTable( {
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel' , 'print',
                // {
                //     extend: 'pdfHtml5',
                //     exportOptions: {
                //         columns: [0, 1, 2, 3,   5]
                //     },
                //     text: 'Save as PDF',
                // }
            ]
        } );
    } );
</script>
@endsection
