@extends('layouts.admin_layout')



@section('content')


<div class="container body">

<div class="row card"  >

    <div class="card-body bg-white">
        <div class="page-title">
            <div class="card-title">
                <h3>Streets</h3>
            </div>
        </div>
        <div class="clearfix"></div>
        <?php if(isset($msg)){?>
        <div class="success_message"><?php echo $msg; ?></div>
        <?php }?>
        <table id="example" class="table table-striped responsive-utilities jambo_table">
            <thead>
            <tr class="headings">
                <th  >Scheme Name</th>
                <th  >Sector</th>
                <th  >Street Name</th>
                <th align="right" class=" no-link last"><span class="nobr">Action</span></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach(\App\Models\Street::all() as $row){?>
            <tr class="odd pointer">
                <td class="">{{isset($row->scheme->name) ? $row->scheme->name : "-" }}</td>
                <td class=""><?php echo $row->code?></td>
                <td class=""><?php echo $row->name;?></td>
                <td align="left" class=" last">
                    <a style="display:none" href=" " class="btn btn-info btn-xs"><i class="fa fa-search"></i>
                        View Stock Details </a>
                    <a href="{{route('streets.edit',[  $row->id])}}" class="btn btn-info btn-xs"><i class="fa fa-pencil"></i> Edit </a>
                    <a style="display:none" href=" " class="btn btn-danger btn-xs" onClick="return confirm('Are you sure to delete this user ?')"><i class="fa fa-trash-o"></i> Delete </a>
                </td>
            </tr>
            <?php }?>
            </tbody>
        </table>
    </div>

    <div class="clear"></div>
    <!-- footer content -->

<!-- /footer content -->
</div>
<!-- /page content -->
</div>
</div>





@endsection
