@extends('layouts.admin_layout')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.company.title_singular') }}
    </div>

    <div class="card-body">
        <form action="{{ route("admin.companies.update", [$company->id]) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="form-group {{ $errors->has('author_name') ? 'has-error' : '' }}">
                <label for="company">{{ trans('cruds.comment.fields.author_name') }}*</label>
                <input type="text" id="company" name="company" class="form-control" value="{{ old('author_name', isset($company) ? $company->company : '') }}" required>
                @if($errors->has('company'))
                    <em class="invalid-feedback">
                        {{ $errors->first('company') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('cruds.comment.fields.author_name_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('author_email') ? 'has-error' : '' }}">
                <label for="email">{{ trans('cruds.company.fields.email') }}*</label>
                <input type="text" id="email" name="email" class="form-control" value="{{ old('email', isset($company) ? $company->email : '') }}" required>
                @if($errors->has('email'))
                    <em class="invalid-feedback">
                        {{ $errors->first('email') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('cruds.comment.fields.author_email_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('author_email') ? 'has-error' : '' }}">
                <label for="email">{{ trans('cruds.company.fields.address') }}*</label>
                <input type="text" id="address" name="address" class="form-control" value="{{ old('address', isset($company) ? $company->address : '') }}" required>
                @if($errors->has('address'))
                    <em class="invalid-feedback">
                        {{ $errors->first('address') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('cruds.comment.fields.author_email_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('comment_text') ? 'has-error' : '' }}">
                <label for="comment_text">{{ trans('cruds.company.fields.details') }}*</label>
                <textarea id="details" name="details" class="form-control " required>{{ old('details', isset($company) ? $company->details : '') }}</textarea>
                @if($errors->has('details'))
                    <em class="invalid-feedback">
                        {{ $errors->first('details') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('cruds.comment.fields.comment_text_helper') }}
                </p>
            </div>
            <div>
                <input class="btn btn-danger" type="submit" value="{{ trans('global.save') }}">
            </div>
        </form>


    </div>
</div>
@endsection
