<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ItemController;
use Illuminate\Database\Schema\Blueprint;
use App\Http\Controllers\SalaryController;
use App\Http\Controllers\StreetController;
use \App\Http\Controllers\SchemeController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\PayslipController;
use App\Http\Controllers\ContractController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\PaymentsController;
use App\Http\Controllers\TransferController;
use App\Http\Controllers\AllotmentController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\UserAnswersController;
use App\Http\Controllers\InstallmentsController;
use App\Http\Controllers\InstallmentDetailController;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use jeremykenedy\LaravelRoles\App\Http\Controllers\LaravelRolesController;





/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('dashboard');
})->middleware('auth');
Route::get('/migration', function () {

    Schema::create('employees', function (Blueprint $table) {
        $table->id();
        $table->string('name');
        $table->string('father_name')->nullable();
        $table->string('email', 191)->unique();
        $table->string('position')->nullable();
        $table->decimal('basic_salary', 10, 2);
        $table->date('appointment_date')->nullable();
        $table->date('promotion_date')->nullable();
        $table->string('job_type')->nullable();
        $table->string('personal_number')->nullable();
        $table->integer('leave_balance')->default(0);
        $table->string('reporting_officer')->nullable();
        $table->integer('sick_leaves')->default(0);
        $table->integer('casual_leaves')->default(0);
        $table->integer('earned_leaves')->default(0);
        $table->timestamps();
    });

    Schema::create('salaries', function (Blueprint $table) {
        $table->id();
        $table->foreignId('employee_id')->constrained()->onDelete('cascade');
        $table->decimal('basic_salary', 10, 2);
        $table->decimal('allowances', 10, 2)->default(0);
        $table->decimal('deductions', 10, 2)->default(0);
        $table->decimal('net_salary', 10, 2);
        $table->date('salary_month');
        $table->timestamps();
    });

    Schema::create('payslips', function (Blueprint $table) {
        $table->id();
        $table->foreignId('employee_id')->constrained()->onDelete('cascade');
        $table->foreignId('salary_id')->constrained()->onDelete('cascade');
        $table->string('payslip_number', 191)->unique();

        $table->timestamps();
    });


    return "migration done";
})->name('migration');

Route::get('cache', function () {

    $output = array();
    $output[] = Artisan::call('config:clear');
    $output[] = Artisan::call('config:cache');

    $output[] = Artisan::call('route:clear');
    $output[] = Artisan::call('route:clear');
    dd($output);
});

Auth::routes();

Route::get('/home', [HomeController::class, 'index'])->name('home');
Route::get('/profile', [SchemeController::class, 'profile'])->name('profile');

Route::resource('roles', LaravelRolesController::class);
Route::resource('schemes', SchemeController::class);
Route::resource('allotments', AllotmentController::class);
Route::resource('payments', PaymentsController::class);

Route::resource('installments', InstallmentsController::class);

Route::get('transfer/plot/{id}', [App\Http\Controllers\TransferController::class, 'plot_transfer'])->name('installment.create');
Route::resource('transfer', TransferController::class);


Route::get('installment/{allotment}', [InstallmentsController::class, 'create'])->name('installment.create');

Route::post('installment/submit', [InstallmentsController::class, 'add_installments'])->name('installments.user.add');


Route::resource('streets', StreetController::class);
Route::resource('items', ItemController::class);
Route::post('tickets/media', 'TicketController@storeMedia')->name('tickets.storeMedia');
Route::resource('contracts', ContractController::class);
Route::resource('inventory', InventoryController::class);

Route::resource('departments', DepartmentController::class);

Route::resource('installmentdetail', InstallmentDetailController::class);

Route::post('update/questions', [UserAnswersController::class, 'add_info'])->name('update.questions');

Route::get('/schemes/plots', [SchemeController::class, 'show']);
Route::get('/schemes/plots/categories', [SchemeController::class, 'scheme_plot_categories']);


//----------------------------------


Route::group(['prefix' => 'admin', 'as' => 'admin.', 'middleware' => ['auth']], function () {



    // Contracts
    Route::resource('contracts', ContractController::class);

    // Companies
    Route::resource('companies', CompanyController::class);

    // Items
    Route::resource('items', ItemController::class);

    // Inventory
    Route::resource('inventory', InventoryController::class);

    Route::resource('salaries', controller: SalaryController::class);
    Route::resource('employees', 'App\Http\Controllers\EmployeeController');
    Route::get('payslips/generate/{salary}', [PayslipController::class, 'generate']);
    Route::get('payslips/{payslip}', [PayslipController::class, 'show']);
    Route::get('/hello', function () {
        return 'hello';
    })->name('hello');
    Route::get('/payslip/{employeeId}/{month}', [PayslipController::class, 'showPayslip'])->name('payslip.show');


    // Route::resource('inventory', 'App\Http\Controllers\InventoryController');
    Route::get('/inventory/assign/list', [InventoryController::class, 'assign_list'])->name('inventory.assign.list');
    Route::get('/inventory/assign/item', [InventoryController::class, 'assign_create'])->name('inventory.assign.item');
    Route::post('/inventory/assign/store', [InventoryController::class, 'assign_store'])->name('inventory.assign.store');


    // departments

    Route::resource('departments', 'App\Http\Controllers\DepartmentController');

    // tenants

    Route::resource('tenants', 'App\Http\Controllers\TenantController');

    // Resources

    Route::resource('resources', 'App\Http\Controllers\ResourcesController');

    Route::post('mass_destroy', 'App\Http\Controllers\ResourcesController@destroyall')->name('comments.massDestroy');
    // Resource Admin
    Route::resource('resource-admins', 'App\Http\Controllers\ResourceAdminController');

    // Resource Approvals
    Route::resource('resource-approvals', 'App\Http\Controllers\ResourceApprovalController');
    Route::resource('departments', 'App\Http\Controllers\DepartmentController');


    // Resource Approvals
    Route::resource('subs', 'App\Http\Controllers\ResourceSubGroupController');

    // Resources
    Route::resource('resource-requests', 'App\Http\Controllers\ResourceRequestController');

    Route::get('{status}/{approval_id}', 'App\Http\Controllers\ResourceApprovalController@updateStatus')->name('resource.approve');



});
// Download
Route::get('get_file/{mediaItem}', function (Media $mediaItem) {
    return response()->download($mediaItem->getPath(), $mediaItem->file_name);
})->name('get_files');






//---------------------------------
