
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payslip</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .payslip {
            border: 2px solid #000;
            padding: 20px;
            max-width: 800px;
            margin: auto;
            font-family: Arial, sans-serif;
        }

        .payslip-title {
            font-size: 18px;
            font-weight: bold;
            text-align: center;
            text-decoration: underline;
            margin-bottom: 20px;
        }

        .totals-row {
            font-weight: bold;
            background-color: #f9f9f9;
        }

        .text-center {
            text-align: center;
        }

        .fw-bold {
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div class="payslip">
        <!-- Header Section -->
        <div class="row mb-4">
            <div class="col-8">
                <h5 class="fw-bold">Company Name</h5>
                <p>Company Address</p>
            </div>
            <div class="col-4 text-end">
                <img src="logo.png" alt="Company Logo" style="width: 50px; height: auto;">
            </div>
        </div>
        <h6 class="payslip-title">Pay Slip for April 2024</h6>

        <!-- Employee and Pay Info -->
        <table class="table table-bordered">
            <tbody>
                <tr>
                    <td>Employee ID:</td>
                    <td><?php echo e($employee->id ?? 'N/A'); ?></td>
                    <td>UAN:</td>
                    <td><?php echo e($employee->uan ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>Employee Name:</td>
                    <td><?php echo e($employee->name ?? 'N/A'); ?></td>
                    <td>PF No.:</td>
                    <td><?php echo e($employee->pf_no ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>Designation:</td>
                    <td><?php echo e($employee->designation ?? 'N/A'); ?></td>
                    <td>ESI No.:</td>
                    <td><?php echo e($employee->esi_no ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>Department:</td>
                    <td><?php echo e($employee->department ?? 'N/A'); ?></td>
                    <td>Bank:</td>
                    <td><?php echo e($employee->bank_name ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>Date of Joining:</td>
                    <td><?php echo e($employee->date_of_joining ?? 'N/A'); ?></td>
                    <td>Account No.:</td>
                    <td><?php echo e($employee->account_no ?? 'N/A'); ?></td>
                </tr>
            </tbody>
        </table>

        <!-- Gross Wages and Leave Details -->
        <table class="table table-bordered text-center">
            <tbody>
                <tr>
                    <td>Gross Wages</td>
                    <td>&#8377; <?php echo e($salary->gross_salary ?? '0.00'); ?></td>
                    <td>Total Working Days</td>
                    <td><?php echo e($salary->working_days ?? 30); ?></td>
                    <td>Leaves</td>
                    <td><?php echo e($salary->leaves ?? 0); ?></td>
                </tr>
                <tr>
                    <td>LOP Days</td>
                    <td><?php echo e($salary->lop_days ?? 0); ?></td>
                    <td>Paid Days</td>
                    <td><?php echo e($salary->paid_days ?? 30); ?></td>
                </tr>
            </tbody>
        </table>

        <!-- Earnings and Deductions -->
        <table class="table table-bordered text-center">
            <thead>
                <tr>
                    <th>Earnings</th>
                    <th>Amount (&#8377;)</th>
                    <th>Deductions</th>
                    <th>Amount (&#8377;)</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Basic</td>
                    <td><?php echo e($salary->basic_salary ?? '0.00'); ?></td>
                    <td>EPF</td>
                    <td><?php echo e($salary->epf ?? '0.00'); ?></td>
                </tr>
                <tr>
                    <td>HRA</td>
                    <td><?php echo e($salary->hra ?? '0.00'); ?></td>
                    <td>ESI</td>
                    <td><?php echo e($salary->esi ?? '0.00'); ?></td>
                </tr>
                <tr>
                    <td>Conveyance Allowance</td>
                    <td><?php echo e($salary->conveyance_allowance ?? '0.00'); ?></td>
                    <td>Professional Tax</td>
                    <td><?php echo e($salary->professional_tax ?? '0.00'); ?></td>
                </tr>
                <tr>
                    <td>Medical Allowance</td>
                    <td><?php echo e($salary->medical_allowance ?? '0.00'); ?></td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td>Other Allowances</td>
                    <td><?php echo e($salary->other_allowances ?? '0.00'); ?></td>
                    <td></td>
                    <td></td>
                </tr>
                <tr class="totals-row">
                    <td>Total Earnings</td>
                    <td><?php echo e($salary->total_earnings ?? '0.00'); ?></td>
                    <td>Total Deductions</td>
                    <td><?php echo e($salary->total_deductions ?? '0.00'); ?></td>
                </tr>
                <tr class="totals-row">
                    <td colspan="3">Net Salary</td>
                    <td><?php echo e($salary->net_salary ?? '0.00'); ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
<?php /**PATH D:\projects\hmis\resources\views/salary/show.blade.php ENDPATH**/ ?>