<?php $__env->startSection('content'); ?>
    <?php

    ?>
    <style>
        .btn.disabled,
        .btn.disabled:focus,
        .btn.disabled:hover {
            pointer-events: none;
            opacity: 0.65;
            /* Adjust as needed */
        }

        .btn[disabled] {
            cursor: not-allowed;
        }
    </style>
    <div class="container-fluid w-100">
        <form method="post" action="<?php echo e(route('schemes.update', [1])); ?>">
            <?php echo method_field('patch'); ?>
            <?php echo csrf_field(); ?>

            <?php if(Session::has('updated')): ?>
                <div class="alert alert-success alert-dismissible col-3 offset-4 mt-3 fade show" role="alert">
                    <strong>Updated!</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>

            <?php if(Session::has('alloted')): ?>
                <div class="alert alert-success alert-dismissible col-3 offset-4 mt-3 fade show" role="alert">
                    <strong><?php echo e(session('alloted')); ?></strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>

            <h3 class="display-5 bg-white shadow-sm m-2">Export Report</h3>

            <table class="table table-responsive table-hover bg-white w-100" id="table_allotment">
                <thead>
                    <tr>
                        <th>Scheme</th>
                        <th>App #</th>
                        <th>Quota / Plot</th>
                        <th>Name</th>
                        <th>DOB</th>
                        <th>NIC</th>
                        <th>Father</th>
                        <th>Email</th>
                        <th>Addresses</th>
                        <th>Contacts</th>
                        <th>Nominee</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $allotments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allotment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <figure>
                                    <?php if($allotment->getFirstMediaUrl('allotment')): ?>
                                        <img src="<?php echo e(asset($allotment->getFirstMediaUrl('allotment'))); ?>"
                                            class="img-responsive img-circle shadow-sm"
                                            style="height: 102px; width: 104px;">
                                    <?php endif; ?>
                                    <figcaption class="font-weight-bold mx-auto mt-1 text-center">
                                        <?php echo e($allotment->scheme ? $allotment->scheme->name : 'No scheme is selected'); ?>


                                    </figcaption>
                                </figure>
                            </td>
                            <td><?php echo e($allotment->application_no); ?></td>
                            <td>
                                <?php if($allotment->plot): ?>
                                    <?php echo e($allotment->plot->name ?? 'No plot is selected'); ?>


                                    <span class="badge badge-success m-2"><?php echo e($allotment->size->name ?? ''); ?></span>
                                <?php else: ?>
                                    <?php echo e($allotment->plot->name ?? 'No plot is selected'); ?>

                                <?php endif; ?>
                            </td>
                            <td><?php echo e($allotment->applicant_name); ?></td>
                            <td><?php echo e($allotment->dob); ?></td>
                            <td><?php echo e($allotment->cnic); ?></td>
                            <td><?php echo e($allotment->father_name); ?></td>
                            <td><?php echo e($allotment->email); ?></td>
                            <td>
                                <?php if($allotment->postal_address): ?>
                                    <span class="badge badge-success m-1"><?php echo e($allotment->postal_address); ?></span>
                                <?php endif; ?>
                                <?php if($allotment->permanent_address): ?>
                                    <span class="badge badge-success m-1"><?php echo e($allotment->permanent_address); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($allotment->contact_1): ?>
                                    <span class="badge badge-secondary m-1"><?php echo e($allotment->contact_1); ?></span>
                                <?php endif; ?>
                                <?php if($allotment->contact_2): ?>
                                    <span class="badge badge-secondary m-1"><?php echo e($allotment->contact_2); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($allotment->nominee_name): ?>
                                    <span class="badge badge-secondary m-1">Name - <?php echo e($allotment->nominee_name); ?></span>
                                <?php endif; ?>
                                <?php if($allotment->nominee_contact): ?>
                                    <span class="badge badge-secondary m-1">Contact -
                                        <?php echo e($allotment->nominee_contact); ?></span>
                                <?php endif; ?>
                                <?php if($allotment->nominee_relation): ?>
                                    <span class="badge badge-secondary m-1">Relation -
                                        <?php echo e($allotment->nominee_relation); ?></span>
                                <?php endif; ?>
                                <?php if($allotment->nominee_father_name): ?>
                                    <span class="badge badge-secondary m-1">Father Name -
                                        <?php echo e($allotment->nominee_father_name); ?></span>
                                <?php endif; ?>
                                <?php if($allotment->nominee_cnic): ?>
                                    <span class="badge badge-secondary m-1">CNIC - <?php echo e($allotment->nominee_cnic); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?php echo e(route('allotments.edit', $allotment->id)); ?>"
                                    class="btn btn-sm m-1 btn-outline-success">
                                    <span class="typcn typcn-pencil menu-icon"></span> Edit
                                </a>
                                <a href="<?php echo e($allotment->plot ? route('installment.create', $allotment->id) : '#'); ?>"
                                    class="btn btn-sm m-1 btn-outline-secondary <?php echo e(!$allotment->plot ? 'disabled' : ''); ?>"
                                    <?php echo e(!$allotment->plot ? 'tabindex="-1" aria-disabled="true" title="Please select a category"' : ''); ?>>
                                    <span class="typcn typcn-chart-bar menu-icon"></span> Installments
                                </a>

                                <a href="<?php echo e(url('transfer/plot/' . $allotment->id)); ?>"
                                    class="btn btn-sm m-1 btn-outline-primary">
                                    <span class="typcn typcn-arrow-repeat menu-icon"></span> Transfers
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </form>

        <div class="d-flex justify-content-center">
            
        </div>
    </div>

    <script>
        function add_option(id) {
            var start = '<div class="col-auto input-group-append mt-2">';
            var option =
                '<input type="text" class="form-control w-100" required style="width: auto !important;" name="option_' +
                id + '[]">';
            var button =
                '<button class="btn btn-sm btn-outline-warning btn-icon-append" onclick="delete_option(this.id)"> ' +
                '<span class="mdi mdi-delete-outline"></span> </button>';
            var end = '</div>';
            var stringed = start + option + button + end;
            $("#unique_" + id).append(stringed);
        }
    </script>

    <script>
        $(document).ready(function() {
            $('#table_allotment').DataTable({
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'print',
                    {
                        extend: 'pdfHtml5',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 5, 6, 8, 9]
                        },
                        text: 'Save as PDF',
                    }
                ]
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/housing2kpgov/public_html/hmis.housingkp.gov.pk/resources/views/allotments/index.blade.php ENDPATH**/ ?>