<?php $__env->startSection('content'); ?>
    <style>
        <style>.pagination {
            margin: 20px 0;
        }

        .pagination .page-link {
            font-size: 0.875rem;
            /* Adjust font size */
            padding: 5px 10px;
            /* Adjust padding */
        }

        .pagination .page-item.active .page-link {
            background-color: #007bff;
            /* Adjust active background color */
            border-color: #007bff;
        }

        .pagination .page-link:hover {
            background-color: #e9ecef;
            /* Hover effect */
        }
    </style>
    </style>
    <div class="container-fluid">
        <div class="row mb-4">
            <div class="col-sm-6">
                <h3 class="mb-0 font-weight-bold"><?php echo e(\Illuminate\Support\Facades\Auth::user()->name); ?></h3>
            </div>
            <div class="col-sm-6">
                <div class="d-flex align-items-center justify-content-md-end">
                    <div class="dropdown mr-2">
                        <button class="btn btn-outline-secondary dropdown-toggle" type="button" id="dropdownMenu"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="typcn typcn-calendar-outline mr-2"></i>Last 7 days
                        </button>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenu">
                            <h6 class="dropdown-header">Schemes</h6>
                            <a class="dropdown-item" href="#">All</a>
                        </div>
                    </div>
                    <button type="button" class="btn btn-success text-white">
                        <i class="mdi mdi-arrow-down"></i> Load
                    </button>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-md-7 d-flex">
                <div class="card flex-fill">
                    <div class="card-body">
                        <h4 class="card-title text-center bg-primary text-white p-3 rounded">Details</h4>
                        <div class="row mt-3">
                            <div class="col-lg-6">
                                <div class="card bg-light p-3 shadow-sm">
                                    <p class="text-center h5 mb-2">Total Plots Allotted</p>
                                    <div class="h1 text-center font-weight-bold"><?php echo e(\App\Models\Allotment::count()); ?></div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="card bg-light p-3 shadow-sm">
                                    <p class="text-center h5 mb-2">Amount Received</p>
                                    <div class="h1 text-center text-success font-weight-bold">
                                        <?php echo e(number_format(\App\Models\InstallmentDetail::sum('amount'), 0, '.', ',')); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 mt-3">
                                <div class="card bg-light p-3 shadow-sm">
                                    <p class="text-center h5 mb-2">Over Due</p>
                                    <div class="h1 text-center text-danger font-weight-bold">0</div>
                                </div>
                            </div>
                            <div class="col-lg-6 mt-3">
                                <div class="card bg-light p-3 shadow-sm">
                                    <p class="text-center h5 mb-2">Total Revenue</p>
                                    <div class="h1 text-center text-danger font-weight-bold">
                                        <?php echo e(number_format(\App\Models\UserInstallment::sum('amount'), 0, '.', ',')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-5 d-flex">
                <div class="card flex-fill">
                    <div class="card-body">
                        <h4 class="card-title text-center bg-primary text-white p-3 rounded">Schemes</h4>
                        <div class="row mt-3">
                            <div class="col-lg-6">
                                <div class="card bg-light p-3 shadow-sm">
                                    <p class="text-center h5 mb-2">Active Schemes</p>
                                    <div class="h1 text-center font-weight-bold">
                                        <?php echo e(\App\Models\Scheme::where('status', 'active')->count()); ?></div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="card bg-light p-3 shadow-sm">
                                    <p class="text-center h5 mb-2">Total Schemes</p>
                                    <div class="h1 text-center font-weight-bold"><?php echo e(\App\Models\Scheme::count()); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-xl-12 d-flex">
                <div class="card flex-fill">
                    <div class="card-body">
                        <h4 class="card-title"> <?php echo e(date('F')); ?> Payments</h4>
                        <div class="table-responsive">
                            <table id="paymentsTable" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>User</th>
                                        <th class="text-center">Amount</th>
                                        <th class="text-center">Scheme</th>
                                        <th class="text-center">Quota</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $payments = \App\Models\UserInstallment::paginate(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($payment->allotment ? $payment->allotment->applicant_name : ''); ?></td>
                                            <td class="text-center"><?php echo e($payment->amount); ?></td>
                                            <td class="text-center">
                                                <?php echo e($payment->allotment ? $payment->allotment->scheme->name : ''); ?></td>
                                            <td class="text-center">
                                                <?php echo e($payment->allotment ? $payment->allotment->quota : ''); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                            <div class="d-flex justify-content-center">
                                <?php echo e($payments->links('pagination::bootstrap-4')); ?>


                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
        </div>


        <div class="row mb-4">

            <div class="col-xl-6 d-flex">
                <div class="card flex-fill">
                    <div class="card-body">
                        <h4 class="card-title">Annual Revenue</h4>
                        <canvas id="barChart"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 d-flex">
                <div class="card flex-fill">
                    <div class="card-body">
                        <h4 class="card-title">Revenue by Scheme</h4>
                        <canvas id="pieChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->startSection('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // Bar Chart
        var ctx = document.getElementById('barChart').getContext('2d');
        var barChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: ['January', 'February', 'March', 'April', 'May', 'June', 'July'],
                datasets: [{
                    label: 'Revenue',
                    data: [12000, 15000, 17000, 20000, 22000, 24000, 27000],
                    backgroundColor: 'rgba(54, 162, 235, 0.2)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        // Pie Chart
        var ctx = document.getElementById('pieChart').getContext('2d');
        var pieChart = new Chart(ctx, {
            type: 'pie',
            data: {
                labels: ['Scheme A', 'Scheme B', 'Scheme C', 'Scheme D'],
                datasets: [{
                    label: 'Revenue by Scheme',
                    data: [30, 25, 20, 25],
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.2)',
                        'rgba(75, 192, 192, 0.2)',
                        'rgba(255, 206, 86, 0.2)',
                        'rgba(153, 102, 255, 0.2)'
                    ],
                    borderColor: [
                        'rgba(255, 99, 132, 1)',
                        'rgba(75, 192, 192, 1)',
                        'rgba(255, 206, 86, 1)',
                        'rgba(153, 102, 255, 1)'
                    ],
                    borderWidth: 1
                }]
            }
        });
    </script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap4.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#paymentsTable').DataTable({
                paging: false, // Disable default pagination
                info: false, // Disable table info
                ordering: true, // Enable sorting
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projects\hmis\resources\views/dashboard.blade.php ENDPATH**/ ?>