<?php $__env->startSection('content'); ?>
    <div class="container">
        <style>
            .item {
                margin-bottom: 10px !important;
            }
        </style>

        <?php if(session()->has('created')): ?>
            <span class="row mx-auto font-weight-bolder text-center mt-2 alert alert-success">
                <?php echo e(session('created')); ?>

            </span>
        <?php endif; ?>

        <h3 class="bg-white card-header m-3"> Create Installment </h3>

        <form method="POST" action="<?php echo e(route('installments.store')); ?>" id="demo-form2" class="form-inline form-label-left p-3"
            enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row bg-white shadow-sm p-3">
                <div class="item form-group">
                    <label class="control-label col-md-4 col-sm-4 col-xs-6" for="scheme_id"> Scheme <span
                            class="required">*</span></label>
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <select class="form-control col-md-12 col-xs-6" id="scheme_id" name="scheme_id" required>
                            <option value="">--Select Scheme--</option>
                            <?php $__currentLoopData = \App\Models\Scheme::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $scheme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($scheme->id); ?>"
                                    <?php echo e(isset($selected) && $selected->scheme_id == $scheme->id ? 'selected' : ''); ?>>
                                    <?php echo e($scheme->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="item form-group">
                    <label class="control-label col-md-4 col-sm-4 col-xs-6" for="size_id"> Plot Size <span
                            class="required">*</span></label>
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <select class="form-control col-md-12 col-xs-6" id="size_id" name="size_id" required>
                            <option value="">--Select Plot Size--</option>
                            <?php $__currentLoopData = \App\Models\PlotSizes::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($size->id); ?>"
                                    <?php echo e(isset($plot) && $plot->size_id == $size->id ? 'selected' : ''); ?>>
                                    <?php echo e($size->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="item form-group">
                    <label class="control-label col-md-4 col-sm-4 col-xs-6" for="category_id"> Allotment Category <span
                            class="required">*</span></label>
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <select class="form-control col-md-12 col-xs-6" id="category_id" name="category_id" required>
                            <option value="">--Select Category--</option>
                            <?php $__currentLoopData = \App\Models\PlotCategories::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>"
                                    <?php echo e(isset($plot) && $plot->category_id == $category->id ? 'selected' : ''); ?>>
                                    <?php echo e($category->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-md-4 col-sm-4 col-xs-6" for="total_installments"> Total Installments
                        <span class="required">*</span></label>
                    <div class="col-md-2 col-sm-2 col-xs-6">
                        <input type="number" class="form-control" name="total_installments" required>
                    </div>
                </div>

                <div class="d-flex m-4 justify-content-center">
                    <button type="submit" class="btn btn-primary">Create Installments</button>
                </div>

                <div class="ln_solid"></div>
            </div>
        </form>

        <h2 class="bg-white card-header m-3"> Installments </h2>

        <div class="col-md-12">
            <div class="card">
                <table class="table table-hover table-responsive">
                    <thead>
                        <tr>
                            <th style="width: 10%;">Serial #</th>
                            <th style="width: 10%;">Scheme</th>
                            <th style="width: 10%;">Plot Size</th>
                            <th style="width: 10%;">Category</th>
                            <th class="text-center" style="width: 10%;">Total Installments</th>
                            <th class="text-center" style="width: 10%;">Define</th>
                        </tr>
                    </thead>
                    <tbody class="table-body bg-white card-body">
                        <?php $__currentLoopData = $installments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $installment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($installment->id); ?></td>
                                <td><?php echo e($installment->scheme->name); ?></td>
                                <td><?php echo e($installment->plot->name); ?></td>
                                <td><?php echo e($installment->category ? $installment->category->name : 'No category is selected'); ?>

                                </td>
                                <td class="text-center"><?php echo e($installment->total_installments); ?></td>
                                <td class="text-center">
                                    <a href="<?php echo e(route('installmentdetail.edit', $installment->id)); ?>"
                                        class="btn btn-primary">Define</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <!-- Add pagination links -->
                <div class="d-flex justify-content-center">
                    <?php echo e($installments->links()); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/housing2kpgov/public_html/hmis.housingkp.gov.pk/resources/views/installments/create.blade.php ENDPATH**/ ?>