<?php $__env->startSection('content'); ?>


<div class="container-fluid  w-100">
<form method="post" action="<?php echo e(route('schemes.update',[1])); ?>">
<?php echo method_field('patch'); ?>
<?php echo csrf_field(); ?>

<?php if(Session::has('updated')): ?>
<div class="alert alert-success alert-dismissible col-3 offset-4 mt-3 fade show" role="alert">
<strong>Updated!</strong>
<button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
</button>
</div>
<?php endif; ?>

    <?php if(Session::has('created')): ?>
        <div class="alert alert-success alert-dismissible col-3 offset-4 mt-3 fade show" role="alert">
            <strong><?php echo e(session('created')); ?></strong>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    <?php endif; ?>
    <h3 class="display-5 bg-white shadow-sm m-2">
        Export Report
    </h3>
<table class="table table-hover bg-white w-100" id="table_schemes">
<thead>
<tr >
    <th>  Schemes </th>

    <th>  Total Units </th>


    <th class="text-center"> Type </th>
    <th class="text-center"> Location </th>
    <th class="text-center"> Price </th>
    <th class="text-center"> Status </th>
    <td>
        Action
    </td>
</tr>
</thead>
    <tbody>

<?php $__currentLoopData = \App\Models\Scheme::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $scheme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<tr>
         <td class="mt-4">
                <label class="row text-center mx-auto">
                    <?php echo e($scheme->name); ?>

                </label>
            <button class="btn btn-outline-primary btn-sm mt-3" type="button" data-bs-toggle="collapse" data-bs-target="#collapse_<?php echo e($scheme->id); ?>" aria-expanded="false" aria-controls="collapseExample">
                Plot Quota
            </button>
             <div class="collapse w-100 mt-2" id="collapse_<?php echo e($scheme->id); ?>">
                 <div class="card card-body">
                     <table>
                         <thead>
                         <tr>
                             <th>Plot Size </th>
                             <th>Total </th>
                             <th>Category </th>
                             <th> %
                             </th>
                             <th>
                                 Sceheme Total -
                                 <?php echo e($scheme->total_plots); ?>


                             </th>
                         </tr>
                         </thead>
                         <tbody>

                         <?php $__currentLoopData = $scheme->quota; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             <tr>
                                 <td>
                                     <?php echo e($quota->plot_size->name); ?>

                                 </td>
                                 <td>
                                     <?php echo e($quota->total_units); ?>

                                 </td>
                                 <td>
                                     <?php echo e($quota->category->name); ?>

                                 </td>
                                 <td>
                                        <span class="badge badge-success m-2">
                                        <?php echo e($quota->quota_amount); ?> - Plots
                                        </span>

                                     <span class="badge badge-secondary m-2">
                                        <?php echo e($quota->quota_percentage); ?> %
                                        </span>

                                 </td>

                             </tr>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                         </tbody>
                     </table>
                 </div>
             </div>
         </td>
    <td>
        <?php echo e($scheme->total_plots); ?>


        </td>
        <td class="text-center">
            <?php echo e(ucfirst($scheme->scheme_type)); ?>

        </td>

        <td class="text-center">
            <?php echo e(ucfirst($scheme->location)); ?>


            <span class="badge  m-2 mx-auto d-block badge-dark">
               long - <?php echo e($scheme->longitude); ?>

            </span>
            <span class="badge d-block  mx-auto badge-dark badge-default">
                lat - <?php echo e($scheme->latitude); ?>

            </span>
        </td>

        <td class="text-center fw-bold">
           PKR - <?php echo e(ucfirst($scheme->price)); ?>

        </td>
        <td class="text-center fw-bold">
             <?php echo e(ucfirst($scheme->status)); ?>

        </td>
        <td class="text-center fw-bold">
            <a class="btn btn-primary" href="<?php echo e(route('schemes.edit',[$scheme->id])); ?>">
                        Edit
            </a>
        </td>
</tr>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</tbody>
</table>
</form>
</div>

<script>
function add_option(id){
var start = ' <div class="col-auto input-group-append mt-2">';
var option = '<input type="text" class="form-control w-100" required style="width: auto !important;" name="option_'+id+'[]">';
var button = '<button class="btn btn-sm btn-outline-warning btn-icon-append" onclick="delete_option(this.id)"> ' +
'<span class="mdi mdi-delete-outline"></span> </button>';
var end = '</div>';
var stringed = start+option+button+end;
alert(stringed)
$("#unique_"+id).append(stringed);

}

</script>

<script>
    $(document).ready(function() {
        $('#table_schemes').DataTable( {
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel' , 'print',
                // {
                //     extend: 'pdfHtml5',
                //     exportOptions: {
                //         columns: [0, 1, 2, 3,   5]
                //     },
                //     text: 'Save as PDF',
                // }
            ]
        } );
    } );
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/housing2kpgov/public_html/hmis.housingkp.gov.pk/resources/views/schemes/index.blade.php ENDPATH**/ ?>