<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <table class="table-responsive table table-striped">
            <thead>
                <tr class="fw-bolder bg-white p-3 text-center">
                    <td class="col-md-1">ID</td>
                    <td class="col-md-1 w-75" style="min-width: 150px;">Amount</td>
                    <td class="col-md-1">Installment Name</td>
                    <td class="col-md-2 text-center">Due Date</td>
                    <td class="col-md-2 text-center">Receive Date</td>
                    <td class="col-md-1 text-center">Status</td>
                    <td class="col-md-2 text-center d-none">Receive Amount</td>
                    <td class="col-md-2 text-center">Slip #</td>
                    <td class="col-md-1 text-center">Action</td>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $installment_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $dueDate = new DateTime($details->date);
                        $currentDate = new DateTime();
                        $difference = $dueDate->diff($currentDate);

                        $fine = 0;
                        if ($dueDate < $currentDate) {
                            $fine = ($details->amount / 100) * 2;
                            $daysInMonth = cal_days_in_month(
                                CAL_GREGORIAN,
                                $dueDate->format('m'),
                                $dueDate->format('Y'),
                            );
                            $fine = $fine / $daysInMonth;
                        }

                        // Determine if the installment has been received
                        $user_installment = $user_installments->get($details->id);
                        $isReceived = isset($user_installment);
                        $receivedAmount = $isReceived ? $user_installment->received_amount : 0;
                        $slipNo = $isReceived ? $user_installment->slip_no : '';
                        $status = $isReceived ? 'Received' : 'Pending';
                    ?>

                    <form action="<?php echo e(route('installments.user.add')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <tr>
                            <td class="col-md-1 text-center"><?php echo e($details->id); ?></td>
                            <td class="col-md-1 text-center" style="min-width: 130px;">
                                <div><?php echo e($details->amount); ?></div>
                                <?php if(!$isReceived): ?>
                                    <input class="form-control w-75" style="min-width: 180px;" type="number"
                                        name="received_amount" value="<?php echo e(round($details->amount, 3)); ?>">
                                <?php else: ?>
                                    <div class="badge badge-success m-1">Received - <?php echo e($receivedAmount); ?></div>
                                <?php endif; ?>
                            </td>
                            <td class="col-md-1 text-center"><label><?php echo e($details->name); ?></label></td>
                            <td class="col-md-2 text-center">
                                <label><?php echo e(date('Y-m-d', strtotime($details->date))); ?></label>
                                <?php if(!$isReceived && $fine > 0): ?>
                                    <br>
                                    <strong>Penalty</strong>
                                    <select name="fine_type" id="fine_type" class="form_control" onchange="charge_fine();">
                                        <option value="two_per_anum">- Select Fine -</option>
                                        <option value="two_per_anum">2% per annum - Days <?php echo e($difference->days); ?></option>
                                        <option value="two_per_month">2% per month - Days <?php echo e($difference->days); ?></option>
                                        <option value="one_per_month">1% per month - Days <?php echo e($difference->days); ?></option>
                                        <option value="two_per_day">2% per day</option>
                                    </select>
                                <?php endif; ?>
                            </td>
                            <td class="col-md-2 text-center">
                                <?php if($isReceived): ?>
                                    <?php echo e($user_installment->receiving_date); ?>

                                <?php else: ?>
                                    <input type="date" name="receiving_date" class="date form-control">
                                <?php endif; ?>
                            </td>
                            <td class="col-md-1 text-center">
                                <span
                                    class="badge badge-<?php echo e($isReceived ? 'success' : 'danger'); ?>"><?php echo e($status); ?></span>
                            </td>
                            <td class="col-md-2 text-center" style="min-width: 100px;">
                                <?php if($isReceived): ?>
                                    <?php echo e($slipNo); ?>

                                <?php else: ?>
                                    <input type="text" name="slip_no" class="form-control" style="min-width: 70px;">
                                <?php endif; ?>
                            </td>
                            <input type="hidden" name="installment_detail" value="<?php echo e($details->id); ?>">
                            <input type="hidden" name="allotment" value="<?php echo e($allotment->id); ?>">
                            <td class="col-md-2 text-center">
                                <?php if(!$isReceived): ?>
                                    <button class="btn btn-success btn-sm" type="submit">Receive</button>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                        </tr>
                    </form>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/housing2kpgov/public_html/hmis.housingkp.gov.pk/resources/views/installments/user_installment.blade.php ENDPATH**/ ?>